package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "resourceId"})
@JsonInclude(Include.NON_NULL)
public class AzureAdTokenAuthentication extends CustomExtensionAuthenticationConfiguration implements ODataType {

    @JsonProperty("resourceId")
    protected String resourceId;

    protected AzureAdTokenAuthentication() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.azureAdTokenAuthentication";
    }

    @Property(name="resourceId")
    @JsonIgnore
    public Optional<String> getResourceId() {
        return Optional.ofNullable(resourceId);
    }

    public AzureAdTokenAuthentication withResourceId(String resourceId) {
        AzureAdTokenAuthentication _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.azureAdTokenAuthentication");
        _x.resourceId = resourceId;
        return _x;
    }

    public AzureAdTokenAuthentication withUnmappedField(String name, Object value) {
        AzureAdTokenAuthentication _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAzureAdTokenAuthentication() {
        return new Builder();
    }

    public static final class Builder {
        private String resourceId;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            this.changedFields = changedFields.add("resourceId");
            return this;
        }

        public AzureAdTokenAuthentication build() {
            AzureAdTokenAuthentication _x = new AzureAdTokenAuthentication();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.azureAdTokenAuthentication";
            _x.resourceId = resourceId;
            return _x;
        }
    }

    private AzureAdTokenAuthentication _copy() {
        AzureAdTokenAuthentication _x = new AzureAdTokenAuthentication();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.resourceId = resourceId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AzureAdTokenAuthentication[");
        b.append("resourceId=");
        b.append(this.resourceId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
