package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.AutomaticRepliesStatus;
import odata.msgraph.client.beta.enums.ExternalAudienceScope;

@JsonPropertyOrder({
    "@odata.type", 
    "externalAudience", 
    "externalReplyMessage", 
    "internalReplyMessage", 
    "scheduledEndDateTime", 
    "scheduledStartDateTime", 
    "status"})
@JsonInclude(Include.NON_NULL)
public class AutomaticRepliesSetting implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("externalAudience")
    protected ExternalAudienceScope externalAudience;

    @JsonProperty("externalReplyMessage")
    protected String externalReplyMessage;

    @JsonProperty("internalReplyMessage")
    protected String internalReplyMessage;

    @JsonProperty("scheduledEndDateTime")
    protected DateTimeTimeZone scheduledEndDateTime;

    @JsonProperty("scheduledStartDateTime")
    protected DateTimeTimeZone scheduledStartDateTime;

    @JsonProperty("status")
    protected AutomaticRepliesStatus status;

    protected AutomaticRepliesSetting() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.automaticRepliesSetting";
    }

    @Property(name="externalAudience")
    @JsonIgnore
    public Optional<ExternalAudienceScope> getExternalAudience() {
        return Optional.ofNullable(externalAudience);
    }

    public AutomaticRepliesSetting withExternalAudience(ExternalAudienceScope externalAudience) {
        AutomaticRepliesSetting _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.automaticRepliesSetting");
        _x.externalAudience = externalAudience;
        return _x;
    }

    @Property(name="externalReplyMessage")
    @JsonIgnore
    public Optional<String> getExternalReplyMessage() {
        return Optional.ofNullable(externalReplyMessage);
    }

    public AutomaticRepliesSetting withExternalReplyMessage(String externalReplyMessage) {
        AutomaticRepliesSetting _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.automaticRepliesSetting");
        _x.externalReplyMessage = externalReplyMessage;
        return _x;
    }

    @Property(name="internalReplyMessage")
    @JsonIgnore
    public Optional<String> getInternalReplyMessage() {
        return Optional.ofNullable(internalReplyMessage);
    }

    public AutomaticRepliesSetting withInternalReplyMessage(String internalReplyMessage) {
        AutomaticRepliesSetting _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.automaticRepliesSetting");
        _x.internalReplyMessage = internalReplyMessage;
        return _x;
    }

    @Property(name="scheduledEndDateTime")
    @JsonIgnore
    public Optional<DateTimeTimeZone> getScheduledEndDateTime() {
        return Optional.ofNullable(scheduledEndDateTime);
    }

    public AutomaticRepliesSetting withScheduledEndDateTime(DateTimeTimeZone scheduledEndDateTime) {
        AutomaticRepliesSetting _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.automaticRepliesSetting");
        _x.scheduledEndDateTime = scheduledEndDateTime;
        return _x;
    }

    @Property(name="scheduledStartDateTime")
    @JsonIgnore
    public Optional<DateTimeTimeZone> getScheduledStartDateTime() {
        return Optional.ofNullable(scheduledStartDateTime);
    }

    public AutomaticRepliesSetting withScheduledStartDateTime(DateTimeTimeZone scheduledStartDateTime) {
        AutomaticRepliesSetting _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.automaticRepliesSetting");
        _x.scheduledStartDateTime = scheduledStartDateTime;
        return _x;
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<AutomaticRepliesStatus> getStatus() {
        return Optional.ofNullable(status);
    }

    public AutomaticRepliesSetting withStatus(AutomaticRepliesStatus status) {
        AutomaticRepliesSetting _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.automaticRepliesSetting");
        _x.status = status;
        return _x;
    }

    public AutomaticRepliesSetting withUnmappedField(String name, Object value) {
        AutomaticRepliesSetting _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private ExternalAudienceScope externalAudience;
        private String externalReplyMessage;
        private String internalReplyMessage;
        private DateTimeTimeZone scheduledEndDateTime;
        private DateTimeTimeZone scheduledStartDateTime;
        private AutomaticRepliesStatus status;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder externalAudience(ExternalAudienceScope externalAudience) {
            this.externalAudience = externalAudience;
            this.changedFields = changedFields.add("externalAudience");
            return this;
        }

        public Builder externalReplyMessage(String externalReplyMessage) {
            this.externalReplyMessage = externalReplyMessage;
            this.changedFields = changedFields.add("externalReplyMessage");
            return this;
        }

        public Builder internalReplyMessage(String internalReplyMessage) {
            this.internalReplyMessage = internalReplyMessage;
            this.changedFields = changedFields.add("internalReplyMessage");
            return this;
        }

        public Builder scheduledEndDateTime(DateTimeTimeZone scheduledEndDateTime) {
            this.scheduledEndDateTime = scheduledEndDateTime;
            this.changedFields = changedFields.add("scheduledEndDateTime");
            return this;
        }

        public Builder scheduledStartDateTime(DateTimeTimeZone scheduledStartDateTime) {
            this.scheduledStartDateTime = scheduledStartDateTime;
            this.changedFields = changedFields.add("scheduledStartDateTime");
            return this;
        }

        public Builder status(AutomaticRepliesStatus status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public AutomaticRepliesSetting build() {
            AutomaticRepliesSetting _x = new AutomaticRepliesSetting();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.automaticRepliesSetting";
            _x.externalAudience = externalAudience;
            _x.externalReplyMessage = externalReplyMessage;
            _x.internalReplyMessage = internalReplyMessage;
            _x.scheduledEndDateTime = scheduledEndDateTime;
            _x.scheduledStartDateTime = scheduledStartDateTime;
            _x.status = status;
            return _x;
        }
    }

    private AutomaticRepliesSetting _copy() {
        AutomaticRepliesSetting _x = new AutomaticRepliesSetting();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.externalAudience = externalAudience;
        _x.externalReplyMessage = externalReplyMessage;
        _x.internalReplyMessage = internalReplyMessage;
        _x.scheduledEndDateTime = scheduledEndDateTime;
        _x.scheduledStartDateTime = scheduledStartDateTime;
        _x.status = status;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AutomaticRepliesSetting[");
        b.append("externalAudience=");
        b.append(this.externalAudience);
        b.append(", ");
        b.append("externalReplyMessage=");
        b.append(this.externalReplyMessage);
        b.append(", ");
        b.append("internalReplyMessage=");
        b.append(this.internalReplyMessage);
        b.append(", ");
        b.append("scheduledEndDateTime=");
        b.append(this.scheduledEndDateTime);
        b.append(", ");
        b.append("scheduledStartDateTime=");
        b.append(this.scheduledStartDateTime);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
