package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "includeApplications"})
@JsonInclude(Include.NON_NULL)
public class AuthenticationSourceFilter implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("includeApplications")
    protected List<String> includeApplications;

    @JsonProperty("includeApplications@nextLink")
    protected String includeApplicationsNextLink;

    protected AuthenticationSourceFilter() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.authenticationSourceFilter";
    }

    @Property(name="includeApplications")
    @JsonIgnore
    public CollectionPage<String> getIncludeApplications() {
        return new CollectionPage<String>(contextPath, String.class, this.includeApplications, Optional.ofNullable(includeApplicationsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="includeApplications")
    @JsonIgnore
    public CollectionPage<String> getIncludeApplications(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.includeApplications, Optional.ofNullable(includeApplicationsNextLink), Collections.emptyList(), options);
    }

    public AuthenticationSourceFilter withUnmappedField(String name, Object value) {
        AuthenticationSourceFilter _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<String> includeApplications;
        private String includeApplicationsNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder includeApplications(List<String> includeApplications) {
            this.includeApplications = includeApplications;
            this.changedFields = changedFields.add("includeApplications");
            return this;
        }

        public Builder includeApplications(String... includeApplications) {
            return includeApplications(Arrays.asList(includeApplications));
        }

        public Builder includeApplicationsNextLink(String includeApplicationsNextLink) {
            this.includeApplicationsNextLink = includeApplicationsNextLink;
            this.changedFields = changedFields.add("includeApplications");
            return this;
        }

        public AuthenticationSourceFilter build() {
            AuthenticationSourceFilter _x = new AuthenticationSourceFilter();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.authenticationSourceFilter";
            _x.includeApplications = includeApplications;
            _x.includeApplicationsNextLink = includeApplicationsNextLink;
            return _x;
        }
    }

    private AuthenticationSourceFilter _copy() {
        AuthenticationSourceFilter _x = new AuthenticationSourceFilter();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.includeApplications = includeApplications;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AuthenticationSourceFilter[");
        b.append("includeApplications=");
        b.append(this.includeApplications);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
