package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.AuthenticationMethodTargetType;

@JsonPropertyOrder({
    "@odata.type", 
    "id", 
    "targetedAuthenticationMethod", 
    "targetType"})
@JsonInclude(Include.NON_NULL)
public class AuthenticationMethodsRegistrationCampaignIncludeTarget implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("id")
    protected String id;

    @JsonProperty("targetedAuthenticationMethod")
    protected String targetedAuthenticationMethod;

    @JsonProperty("targetType")
    protected AuthenticationMethodTargetType targetType;

    protected AuthenticationMethodsRegistrationCampaignIncludeTarget() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.authenticationMethodsRegistrationCampaignIncludeTarget";
    }

    @Property(name="id")
    @JsonIgnore
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    public AuthenticationMethodsRegistrationCampaignIncludeTarget withId(String id) {
        AuthenticationMethodsRegistrationCampaignIncludeTarget _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.authenticationMethodsRegistrationCampaignIncludeTarget");
        _x.id = id;
        return _x;
    }

    @Property(name="targetedAuthenticationMethod")
    @JsonIgnore
    public Optional<String> getTargetedAuthenticationMethod() {
        return Optional.ofNullable(targetedAuthenticationMethod);
    }

    public AuthenticationMethodsRegistrationCampaignIncludeTarget withTargetedAuthenticationMethod(String targetedAuthenticationMethod) {
        AuthenticationMethodsRegistrationCampaignIncludeTarget _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.authenticationMethodsRegistrationCampaignIncludeTarget");
        _x.targetedAuthenticationMethod = targetedAuthenticationMethod;
        return _x;
    }

    @Property(name="targetType")
    @JsonIgnore
    public Optional<AuthenticationMethodTargetType> getTargetType() {
        return Optional.ofNullable(targetType);
    }

    public AuthenticationMethodsRegistrationCampaignIncludeTarget withTargetType(AuthenticationMethodTargetType targetType) {
        AuthenticationMethodsRegistrationCampaignIncludeTarget _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.authenticationMethodsRegistrationCampaignIncludeTarget");
        _x.targetType = targetType;
        return _x;
    }

    public AuthenticationMethodsRegistrationCampaignIncludeTarget withUnmappedField(String name, Object value) {
        AuthenticationMethodsRegistrationCampaignIncludeTarget _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String targetedAuthenticationMethod;
        private AuthenticationMethodTargetType targetType;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder targetedAuthenticationMethod(String targetedAuthenticationMethod) {
            this.targetedAuthenticationMethod = targetedAuthenticationMethod;
            this.changedFields = changedFields.add("targetedAuthenticationMethod");
            return this;
        }

        public Builder targetType(AuthenticationMethodTargetType targetType) {
            this.targetType = targetType;
            this.changedFields = changedFields.add("targetType");
            return this;
        }

        public AuthenticationMethodsRegistrationCampaignIncludeTarget build() {
            AuthenticationMethodsRegistrationCampaignIncludeTarget _x = new AuthenticationMethodsRegistrationCampaignIncludeTarget();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.authenticationMethodsRegistrationCampaignIncludeTarget";
            _x.id = id;
            _x.targetedAuthenticationMethod = targetedAuthenticationMethod;
            _x.targetType = targetType;
            return _x;
        }
    }

    private AuthenticationMethodsRegistrationCampaignIncludeTarget _copy() {
        AuthenticationMethodsRegistrationCampaignIncludeTarget _x = new AuthenticationMethodsRegistrationCampaignIncludeTarget();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.targetedAuthenticationMethod = targetedAuthenticationMethod;
        _x.targetType = targetType;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AuthenticationMethodsRegistrationCampaignIncludeTarget[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("targetedAuthenticationMethod=");
        b.append(this.targetedAuthenticationMethod);
        b.append(", ");
        b.append("targetType=");
        b.append(this.targetType);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
