package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.AdvancedConfigState;

@JsonPropertyOrder({
    "@odata.type", 
    "excludeTargets", 
    "includeTargets", 
    "snoozeDurationInDays", 
    "state"})
@JsonInclude(Include.NON_NULL)
public class AuthenticationMethodsRegistrationCampaign implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("excludeTargets")
    protected List<ExcludeTarget> excludeTargets;

    @JsonProperty("excludeTargets@nextLink")
    protected String excludeTargetsNextLink;

    @JsonProperty("includeTargets")
    protected List<AuthenticationMethodsRegistrationCampaignIncludeTarget> includeTargets;

    @JsonProperty("includeTargets@nextLink")
    protected String includeTargetsNextLink;

    @JsonProperty("snoozeDurationInDays")
    protected Integer snoozeDurationInDays;

    @JsonProperty("state")
    protected AdvancedConfigState state;

    protected AuthenticationMethodsRegistrationCampaign() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.authenticationMethodsRegistrationCampaign";
    }

    @Property(name="excludeTargets")
    @JsonIgnore
    public CollectionPage<ExcludeTarget> getExcludeTargets() {
        return new CollectionPage<ExcludeTarget>(contextPath, ExcludeTarget.class, this.excludeTargets, Optional.ofNullable(excludeTargetsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="excludeTargets")
    @JsonIgnore
    public CollectionPage<ExcludeTarget> getExcludeTargets(HttpRequestOptions options) {
        return new CollectionPage<ExcludeTarget>(contextPath, ExcludeTarget.class, this.excludeTargets, Optional.ofNullable(excludeTargetsNextLink), Collections.emptyList(), options);
    }

    @Property(name="includeTargets")
    @JsonIgnore
    public CollectionPage<AuthenticationMethodsRegistrationCampaignIncludeTarget> getIncludeTargets() {
        return new CollectionPage<AuthenticationMethodsRegistrationCampaignIncludeTarget>(contextPath, AuthenticationMethodsRegistrationCampaignIncludeTarget.class, this.includeTargets, Optional.ofNullable(includeTargetsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="includeTargets")
    @JsonIgnore
    public CollectionPage<AuthenticationMethodsRegistrationCampaignIncludeTarget> getIncludeTargets(HttpRequestOptions options) {
        return new CollectionPage<AuthenticationMethodsRegistrationCampaignIncludeTarget>(contextPath, AuthenticationMethodsRegistrationCampaignIncludeTarget.class, this.includeTargets, Optional.ofNullable(includeTargetsNextLink), Collections.emptyList(), options);
    }

    @Property(name="snoozeDurationInDays")
    @JsonIgnore
    public Optional<Integer> getSnoozeDurationInDays() {
        return Optional.ofNullable(snoozeDurationInDays);
    }

    public AuthenticationMethodsRegistrationCampaign withSnoozeDurationInDays(Integer snoozeDurationInDays) {
        AuthenticationMethodsRegistrationCampaign _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.authenticationMethodsRegistrationCampaign");
        _x.snoozeDurationInDays = snoozeDurationInDays;
        return _x;
    }

    @Property(name="state")
    @JsonIgnore
    public Optional<AdvancedConfigState> getState() {
        return Optional.ofNullable(state);
    }

    public AuthenticationMethodsRegistrationCampaign withState(AdvancedConfigState state) {
        AuthenticationMethodsRegistrationCampaign _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.authenticationMethodsRegistrationCampaign");
        _x.state = state;
        return _x;
    }

    public AuthenticationMethodsRegistrationCampaign withUnmappedField(String name, Object value) {
        AuthenticationMethodsRegistrationCampaign _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<ExcludeTarget> excludeTargets;
        private String excludeTargetsNextLink;
        private List<AuthenticationMethodsRegistrationCampaignIncludeTarget> includeTargets;
        private String includeTargetsNextLink;
        private Integer snoozeDurationInDays;
        private AdvancedConfigState state;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder excludeTargets(List<ExcludeTarget> excludeTargets) {
            this.excludeTargets = excludeTargets;
            this.changedFields = changedFields.add("excludeTargets");
            return this;
        }

        public Builder excludeTargets(ExcludeTarget... excludeTargets) {
            return excludeTargets(Arrays.asList(excludeTargets));
        }

        public Builder excludeTargetsNextLink(String excludeTargetsNextLink) {
            this.excludeTargetsNextLink = excludeTargetsNextLink;
            this.changedFields = changedFields.add("excludeTargets");
            return this;
        }

        public Builder includeTargets(List<AuthenticationMethodsRegistrationCampaignIncludeTarget> includeTargets) {
            this.includeTargets = includeTargets;
            this.changedFields = changedFields.add("includeTargets");
            return this;
        }

        public Builder includeTargets(AuthenticationMethodsRegistrationCampaignIncludeTarget... includeTargets) {
            return includeTargets(Arrays.asList(includeTargets));
        }

        public Builder includeTargetsNextLink(String includeTargetsNextLink) {
            this.includeTargetsNextLink = includeTargetsNextLink;
            this.changedFields = changedFields.add("includeTargets");
            return this;
        }

        public Builder snoozeDurationInDays(Integer snoozeDurationInDays) {
            this.snoozeDurationInDays = snoozeDurationInDays;
            this.changedFields = changedFields.add("snoozeDurationInDays");
            return this;
        }

        public Builder state(AdvancedConfigState state) {
            this.state = state;
            this.changedFields = changedFields.add("state");
            return this;
        }

        public AuthenticationMethodsRegistrationCampaign build() {
            AuthenticationMethodsRegistrationCampaign _x = new AuthenticationMethodsRegistrationCampaign();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.authenticationMethodsRegistrationCampaign";
            _x.excludeTargets = excludeTargets;
            _x.excludeTargetsNextLink = excludeTargetsNextLink;
            _x.includeTargets = includeTargets;
            _x.includeTargetsNextLink = includeTargetsNextLink;
            _x.snoozeDurationInDays = snoozeDurationInDays;
            _x.state = state;
            return _x;
        }
    }

    private AuthenticationMethodsRegistrationCampaign _copy() {
        AuthenticationMethodsRegistrationCampaign _x = new AuthenticationMethodsRegistrationCampaign();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.excludeTargets = excludeTargets;
        _x.includeTargets = includeTargets;
        _x.snoozeDurationInDays = snoozeDurationInDays;
        _x.state = state;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AuthenticationMethodsRegistrationCampaign[");
        b.append("excludeTargets=");
        b.append(this.excludeTargets);
        b.append(", ");
        b.append("includeTargets=");
        b.append(this.includeTargets);
        b.append(", ");
        b.append("snoozeDurationInDays=");
        b.append(this.snoozeDurationInDays);
        b.append(", ");
        b.append("state=");
        b.append(this.state);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
