package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“A class containing the properties for Audit Property.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "displayName", 
    "newValue", 
    "oldValue"})
@JsonInclude(Include.NON_NULL)
public class AuditProperty implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("newValue")
    protected String newValue;

    @JsonProperty("oldValue")
    protected String oldValue;

    protected AuditProperty() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.auditProperty";
    }

    /**
     * <i>“Display name.”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Display name.”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public AuditProperty withDisplayName(String displayName) {
        AuditProperty _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.auditProperty");
        _x.displayName = displayName;
        return _x;
    }

    /**
     * <i>“New value.”</i>
     * 
     * @return property newValue
     */
    @Property(name="newValue")
    @JsonIgnore
    public Optional<String> getNewValue() {
        return Optional.ofNullable(newValue);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code newValue} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“New value.”</i>
     * 
     * @param newValue
     *            new value of {@code newValue} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code newValue} field changed
     */
    public AuditProperty withNewValue(String newValue) {
        AuditProperty _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.auditProperty");
        _x.newValue = newValue;
        return _x;
    }

    /**
     * <i>“Old value.”</i>
     * 
     * @return property oldValue
     */
    @Property(name="oldValue")
    @JsonIgnore
    public Optional<String> getOldValue() {
        return Optional.ofNullable(oldValue);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code oldValue} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Old value.”</i>
     * 
     * @param oldValue
     *            new value of {@code oldValue} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code oldValue} field changed
     */
    public AuditProperty withOldValue(String oldValue) {
        AuditProperty _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.auditProperty");
        _x.oldValue = oldValue;
        return _x;
    }

    public AuditProperty withUnmappedField(String name, Object value) {
        AuditProperty _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String displayName;
        private String newValue;
        private String oldValue;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Display name.”</i>
         * 
         * @param displayName
         *            value of {@code displayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        /**
         * <i>“New value.”</i>
         * 
         * @param newValue
         *            value of {@code newValue} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder newValue(String newValue) {
            this.newValue = newValue;
            this.changedFields = changedFields.add("newValue");
            return this;
        }

        /**
         * <i>“Old value.”</i>
         * 
         * @param oldValue
         *            value of {@code oldValue} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder oldValue(String oldValue) {
            this.oldValue = oldValue;
            this.changedFields = changedFields.add("oldValue");
            return this;
        }

        public AuditProperty build() {
            AuditProperty _x = new AuditProperty();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.auditProperty";
            _x.displayName = displayName;
            _x.newValue = newValue;
            _x.oldValue = oldValue;
            return _x;
        }
    }

    private AuditProperty _copy() {
        AuditProperty _x = new AuditProperty();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.displayName = displayName;
        _x.newValue = newValue;
        _x.oldValue = oldValue;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AuditProperty[");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("newValue=");
        b.append(this.newValue);
        b.append(", ");
        b.append("oldValue=");
        b.append(this.oldValue);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
