package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.Short;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "album", 
    "albumArtist", 
    "artist", 
    "bitrate", 
    "composers", 
    "copyright", 
    "disc", 
    "discCount", 
    "duration", 
    "genre", 
    "hasDrm", 
    "isVariableBitrate", 
    "title", 
    "track", 
    "trackCount", 
    "year"})
@JsonInclude(Include.NON_NULL)
public class Audio implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("album")
    protected String album;

    @JsonProperty("albumArtist")
    protected String albumArtist;

    @JsonProperty("artist")
    protected String artist;

    @JsonProperty("bitrate")
    protected Long bitrate;

    @JsonProperty("composers")
    protected String composers;

    @JsonProperty("copyright")
    protected String copyright;

    @JsonProperty("disc")
    protected Short disc;

    @JsonProperty("discCount")
    protected Short discCount;

    @JsonProperty("duration")
    protected Long duration;

    @JsonProperty("genre")
    protected String genre;

    @JsonProperty("hasDrm")
    protected Boolean hasDrm;

    @JsonProperty("isVariableBitrate")
    protected Boolean isVariableBitrate;

    @JsonProperty("title")
    protected String title;

    @JsonProperty("track")
    protected Integer track;

    @JsonProperty("trackCount")
    protected Integer trackCount;

    @JsonProperty("year")
    protected Integer year;

    protected Audio() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.audio";
    }

    @Property(name="album")
    @JsonIgnore
    public Optional<String> getAlbum() {
        return Optional.ofNullable(album);
    }

    public Audio withAlbum(String album) {
        Audio _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.audio");
        _x.album = album;
        return _x;
    }

    @Property(name="albumArtist")
    @JsonIgnore
    public Optional<String> getAlbumArtist() {
        return Optional.ofNullable(albumArtist);
    }

    public Audio withAlbumArtist(String albumArtist) {
        Audio _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.audio");
        _x.albumArtist = albumArtist;
        return _x;
    }

    @Property(name="artist")
    @JsonIgnore
    public Optional<String> getArtist() {
        return Optional.ofNullable(artist);
    }

    public Audio withArtist(String artist) {
        Audio _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.audio");
        _x.artist = artist;
        return _x;
    }

    @Property(name="bitrate")
    @JsonIgnore
    public Optional<Long> getBitrate() {
        return Optional.ofNullable(bitrate);
    }

    public Audio withBitrate(Long bitrate) {
        Audio _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.audio");
        _x.bitrate = bitrate;
        return _x;
    }

    @Property(name="composers")
    @JsonIgnore
    public Optional<String> getComposers() {
        return Optional.ofNullable(composers);
    }

    public Audio withComposers(String composers) {
        Audio _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.audio");
        _x.composers = composers;
        return _x;
    }

    @Property(name="copyright")
    @JsonIgnore
    public Optional<String> getCopyright() {
        return Optional.ofNullable(copyright);
    }

    public Audio withCopyright(String copyright) {
        Audio _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.audio");
        _x.copyright = copyright;
        return _x;
    }

    @Property(name="disc")
    @JsonIgnore
    public Optional<Short> getDisc() {
        return Optional.ofNullable(disc);
    }

    public Audio withDisc(Short disc) {
        Audio _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.audio");
        _x.disc = disc;
        return _x;
    }

    @Property(name="discCount")
    @JsonIgnore
    public Optional<Short> getDiscCount() {
        return Optional.ofNullable(discCount);
    }

    public Audio withDiscCount(Short discCount) {
        Audio _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.audio");
        _x.discCount = discCount;
        return _x;
    }

    @Property(name="duration")
    @JsonIgnore
    public Optional<Long> getDuration() {
        return Optional.ofNullable(duration);
    }

    public Audio withDuration(Long duration) {
        Audio _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.audio");
        _x.duration = duration;
        return _x;
    }

    @Property(name="genre")
    @JsonIgnore
    public Optional<String> getGenre() {
        return Optional.ofNullable(genre);
    }

    public Audio withGenre(String genre) {
        Audio _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.audio");
        _x.genre = genre;
        return _x;
    }

    @Property(name="hasDrm")
    @JsonIgnore
    public Optional<Boolean> getHasDrm() {
        return Optional.ofNullable(hasDrm);
    }

    public Audio withHasDrm(Boolean hasDrm) {
        Audio _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.audio");
        _x.hasDrm = hasDrm;
        return _x;
    }

    @Property(name="isVariableBitrate")
    @JsonIgnore
    public Optional<Boolean> getIsVariableBitrate() {
        return Optional.ofNullable(isVariableBitrate);
    }

    public Audio withIsVariableBitrate(Boolean isVariableBitrate) {
        Audio _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.audio");
        _x.isVariableBitrate = isVariableBitrate;
        return _x;
    }

    @Property(name="title")
    @JsonIgnore
    public Optional<String> getTitle() {
        return Optional.ofNullable(title);
    }

    public Audio withTitle(String title) {
        Audio _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.audio");
        _x.title = title;
        return _x;
    }

    @Property(name="track")
    @JsonIgnore
    public Optional<Integer> getTrack() {
        return Optional.ofNullable(track);
    }

    public Audio withTrack(Integer track) {
        Audio _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.audio");
        _x.track = track;
        return _x;
    }

    @Property(name="trackCount")
    @JsonIgnore
    public Optional<Integer> getTrackCount() {
        return Optional.ofNullable(trackCount);
    }

    public Audio withTrackCount(Integer trackCount) {
        Audio _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.audio");
        _x.trackCount = trackCount;
        return _x;
    }

    @Property(name="year")
    @JsonIgnore
    public Optional<Integer> getYear() {
        return Optional.ofNullable(year);
    }

    public Audio withYear(Integer year) {
        Audio _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.audio");
        _x.year = year;
        return _x;
    }

    public Audio withUnmappedField(String name, Object value) {
        Audio _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String album;
        private String albumArtist;
        private String artist;
        private Long bitrate;
        private String composers;
        private String copyright;
        private Short disc;
        private Short discCount;
        private Long duration;
        private String genre;
        private Boolean hasDrm;
        private Boolean isVariableBitrate;
        private String title;
        private Integer track;
        private Integer trackCount;
        private Integer year;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder album(String album) {
            this.album = album;
            this.changedFields = changedFields.add("album");
            return this;
        }

        public Builder albumArtist(String albumArtist) {
            this.albumArtist = albumArtist;
            this.changedFields = changedFields.add("albumArtist");
            return this;
        }

        public Builder artist(String artist) {
            this.artist = artist;
            this.changedFields = changedFields.add("artist");
            return this;
        }

        public Builder bitrate(Long bitrate) {
            this.bitrate = bitrate;
            this.changedFields = changedFields.add("bitrate");
            return this;
        }

        public Builder composers(String composers) {
            this.composers = composers;
            this.changedFields = changedFields.add("composers");
            return this;
        }

        public Builder copyright(String copyright) {
            this.copyright = copyright;
            this.changedFields = changedFields.add("copyright");
            return this;
        }

        public Builder disc(Short disc) {
            this.disc = disc;
            this.changedFields = changedFields.add("disc");
            return this;
        }

        public Builder discCount(Short discCount) {
            this.discCount = discCount;
            this.changedFields = changedFields.add("discCount");
            return this;
        }

        public Builder duration(Long duration) {
            this.duration = duration;
            this.changedFields = changedFields.add("duration");
            return this;
        }

        public Builder genre(String genre) {
            this.genre = genre;
            this.changedFields = changedFields.add("genre");
            return this;
        }

        public Builder hasDrm(Boolean hasDrm) {
            this.hasDrm = hasDrm;
            this.changedFields = changedFields.add("hasDrm");
            return this;
        }

        public Builder isVariableBitrate(Boolean isVariableBitrate) {
            this.isVariableBitrate = isVariableBitrate;
            this.changedFields = changedFields.add("isVariableBitrate");
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            this.changedFields = changedFields.add("title");
            return this;
        }

        public Builder track(Integer track) {
            this.track = track;
            this.changedFields = changedFields.add("track");
            return this;
        }

        public Builder trackCount(Integer trackCount) {
            this.trackCount = trackCount;
            this.changedFields = changedFields.add("trackCount");
            return this;
        }

        public Builder year(Integer year) {
            this.year = year;
            this.changedFields = changedFields.add("year");
            return this;
        }

        public Audio build() {
            Audio _x = new Audio();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.audio";
            _x.album = album;
            _x.albumArtist = albumArtist;
            _x.artist = artist;
            _x.bitrate = bitrate;
            _x.composers = composers;
            _x.copyright = copyright;
            _x.disc = disc;
            _x.discCount = discCount;
            _x.duration = duration;
            _x.genre = genre;
            _x.hasDrm = hasDrm;
            _x.isVariableBitrate = isVariableBitrate;
            _x.title = title;
            _x.track = track;
            _x.trackCount = trackCount;
            _x.year = year;
            return _x;
        }
    }

    private Audio _copy() {
        Audio _x = new Audio();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.album = album;
        _x.albumArtist = albumArtist;
        _x.artist = artist;
        _x.bitrate = bitrate;
        _x.composers = composers;
        _x.copyright = copyright;
        _x.disc = disc;
        _x.discCount = discCount;
        _x.duration = duration;
        _x.genre = genre;
        _x.hasDrm = hasDrm;
        _x.isVariableBitrate = isVariableBitrate;
        _x.title = title;
        _x.track = track;
        _x.trackCount = trackCount;
        _x.year = year;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Audio[");
        b.append("album=");
        b.append(this.album);
        b.append(", ");
        b.append("albumArtist=");
        b.append(this.albumArtist);
        b.append(", ");
        b.append("artist=");
        b.append(this.artist);
        b.append(", ");
        b.append("bitrate=");
        b.append(this.bitrate);
        b.append(", ");
        b.append("composers=");
        b.append(this.composers);
        b.append(", ");
        b.append("copyright=");
        b.append(this.copyright);
        b.append(", ");
        b.append("disc=");
        b.append(this.disc);
        b.append(", ");
        b.append("discCount=");
        b.append(this.discCount);
        b.append(", ");
        b.append("duration=");
        b.append(this.duration);
        b.append(", ");
        b.append("genre=");
        b.append(this.genre);
        b.append(", ");
        b.append("hasDrm=");
        b.append(this.hasDrm);
        b.append(", ");
        b.append("isVariableBitrate=");
        b.append(this.isVariableBitrate);
        b.append(", ");
        b.append("title=");
        b.append(this.title);
        b.append(", ");
        b.append("track=");
        b.append(this.track);
        b.append(", ");
        b.append("trackCount=");
        b.append(this.trackCount);
        b.append(", ");
        b.append("year=");
        b.append(this.year);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
