package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.AttributeType;

@JsonPropertyOrder({
    "@odata.type", 
    "allowMultipleOccurrences", 
    "name", 
    "required", 
    "type"})
@JsonInclude(Include.NON_NULL)
public class AttributeMappingParameterSchema implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("allowMultipleOccurrences")
    protected Boolean allowMultipleOccurrences;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("required")
    protected Boolean required;

    @JsonProperty("type")
    protected AttributeType type;

    protected AttributeMappingParameterSchema() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.attributeMappingParameterSchema";
    }

    @Property(name="allowMultipleOccurrences")
    @JsonIgnore
    public Optional<Boolean> getAllowMultipleOccurrences() {
        return Optional.ofNullable(allowMultipleOccurrences);
    }

    public AttributeMappingParameterSchema withAllowMultipleOccurrences(Boolean allowMultipleOccurrences) {
        AttributeMappingParameterSchema _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.attributeMappingParameterSchema");
        _x.allowMultipleOccurrences = allowMultipleOccurrences;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public AttributeMappingParameterSchema withName(String name) {
        AttributeMappingParameterSchema _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.attributeMappingParameterSchema");
        _x.name = name;
        return _x;
    }

    @Property(name="required")
    @JsonIgnore
    public Optional<Boolean> getRequired() {
        return Optional.ofNullable(required);
    }

    public AttributeMappingParameterSchema withRequired(Boolean required) {
        AttributeMappingParameterSchema _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.attributeMappingParameterSchema");
        _x.required = required;
        return _x;
    }

    @Property(name="type")
    @JsonIgnore
    public Optional<AttributeType> getType() {
        return Optional.ofNullable(type);
    }

    public AttributeMappingParameterSchema withType(AttributeType type) {
        AttributeMappingParameterSchema _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.attributeMappingParameterSchema");
        _x.type = type;
        return _x;
    }

    public AttributeMappingParameterSchema withUnmappedField(String name, Object value) {
        AttributeMappingParameterSchema _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean allowMultipleOccurrences;
        private String name;
        private Boolean required;
        private AttributeType type;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder allowMultipleOccurrences(Boolean allowMultipleOccurrences) {
            this.allowMultipleOccurrences = allowMultipleOccurrences;
            this.changedFields = changedFields.add("allowMultipleOccurrences");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder required(Boolean required) {
            this.required = required;
            this.changedFields = changedFields.add("required");
            return this;
        }

        public Builder type(AttributeType type) {
            this.type = type;
            this.changedFields = changedFields.add("type");
            return this;
        }

        public AttributeMappingParameterSchema build() {
            AttributeMappingParameterSchema _x = new AttributeMappingParameterSchema();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.attributeMappingParameterSchema";
            _x.allowMultipleOccurrences = allowMultipleOccurrences;
            _x.name = name;
            _x.required = required;
            _x.type = type;
            return _x;
        }
    }

    private AttributeMappingParameterSchema _copy() {
        AttributeMappingParameterSchema _x = new AttributeMappingParameterSchema();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.allowMultipleOccurrences = allowMultipleOccurrences;
        _x.name = name;
        _x.required = required;
        _x.type = type;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AttributeMappingParameterSchema[");
        b.append("allowMultipleOccurrences=");
        b.append(this.allowMultipleOccurrences);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("required=");
        b.append(this.required);
        b.append(", ");
        b.append("type=");
        b.append(this.type);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
