package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.AttendeeType;

@JsonPropertyOrder({
    "@odata.type", 
    "proposedNewTime", 
    "status"})
@JsonInclude(Include.NON_NULL)
public class Attendee extends AttendeeBase implements ODataType {

    @JsonProperty("proposedNewTime")
    protected TimeSlot proposedNewTime;

    @JsonProperty("status")
    protected ResponseStatus status;

    protected Attendee() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.attendee";
    }

    @Property(name="proposedNewTime")
    @JsonIgnore
    public Optional<TimeSlot> getProposedNewTime() {
        return Optional.ofNullable(proposedNewTime);
    }

    public Attendee withProposedNewTime(TimeSlot proposedNewTime) {
        Attendee _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.attendee");
        _x.proposedNewTime = proposedNewTime;
        return _x;
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<ResponseStatus> getStatus() {
        return Optional.ofNullable(status);
    }

    public Attendee withStatus(ResponseStatus status) {
        Attendee _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.attendee");
        _x.status = status;
        return _x;
    }

    public Attendee withUnmappedField(String name, Object value) {
        Attendee _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAttendee() {
        return new Builder();
    }

    public static final class Builder {
        private EmailAddress emailAddress;
        private AttendeeType type;
        private TimeSlot proposedNewTime;
        private ResponseStatus status;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder emailAddress(EmailAddress emailAddress) {
            this.emailAddress = emailAddress;
            this.changedFields = changedFields.add("emailAddress");
            return this;
        }

        public Builder type(AttendeeType type) {
            this.type = type;
            this.changedFields = changedFields.add("type");
            return this;
        }

        public Builder proposedNewTime(TimeSlot proposedNewTime) {
            this.proposedNewTime = proposedNewTime;
            this.changedFields = changedFields.add("proposedNewTime");
            return this;
        }

        public Builder status(ResponseStatus status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public Attendee build() {
            Attendee _x = new Attendee();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.attendee";
            _x.emailAddress = emailAddress;
            _x.type = type;
            _x.proposedNewTime = proposedNewTime;
            _x.status = status;
            return _x;
        }
    }

    private Attendee _copy() {
        Attendee _x = new Attendee();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.emailAddress = emailAddress;
        _x.type = type;
        _x.proposedNewTime = proposedNewTime;
        _x.status = status;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Attendee[");
        b.append("emailAddress=");
        b.append(this.emailAddress);
        b.append(", ");
        b.append("type=");
        b.append(this.type);
        b.append(", ");
        b.append("proposedNewTime=");
        b.append(this.proposedNewTime);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
