package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "durationInSeconds", 
    "joinDateTime", 
    "leaveDateTime"})
@JsonInclude(Include.NON_NULL)
public class AttendanceInterval implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("durationInSeconds")
    protected Integer durationInSeconds;

    @JsonProperty("joinDateTime")
    protected OffsetDateTime joinDateTime;

    @JsonProperty("leaveDateTime")
    protected OffsetDateTime leaveDateTime;

    protected AttendanceInterval() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.attendanceInterval";
    }

    @Property(name="durationInSeconds")
    @JsonIgnore
    public Optional<Integer> getDurationInSeconds() {
        return Optional.ofNullable(durationInSeconds);
    }

    public AttendanceInterval withDurationInSeconds(Integer durationInSeconds) {
        AttendanceInterval _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.attendanceInterval");
        _x.durationInSeconds = durationInSeconds;
        return _x;
    }

    @Property(name="joinDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getJoinDateTime() {
        return Optional.ofNullable(joinDateTime);
    }

    public AttendanceInterval withJoinDateTime(OffsetDateTime joinDateTime) {
        AttendanceInterval _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.attendanceInterval");
        _x.joinDateTime = joinDateTime;
        return _x;
    }

    @Property(name="leaveDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLeaveDateTime() {
        return Optional.ofNullable(leaveDateTime);
    }

    public AttendanceInterval withLeaveDateTime(OffsetDateTime leaveDateTime) {
        AttendanceInterval _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.attendanceInterval");
        _x.leaveDateTime = leaveDateTime;
        return _x;
    }

    public AttendanceInterval withUnmappedField(String name, Object value) {
        AttendanceInterval _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer durationInSeconds;
        private OffsetDateTime joinDateTime;
        private OffsetDateTime leaveDateTime;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder durationInSeconds(Integer durationInSeconds) {
            this.durationInSeconds = durationInSeconds;
            this.changedFields = changedFields.add("durationInSeconds");
            return this;
        }

        public Builder joinDateTime(OffsetDateTime joinDateTime) {
            this.joinDateTime = joinDateTime;
            this.changedFields = changedFields.add("joinDateTime");
            return this;
        }

        public Builder leaveDateTime(OffsetDateTime leaveDateTime) {
            this.leaveDateTime = leaveDateTime;
            this.changedFields = changedFields.add("leaveDateTime");
            return this;
        }

        public AttendanceInterval build() {
            AttendanceInterval _x = new AttendanceInterval();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.attendanceInterval";
            _x.durationInSeconds = durationInSeconds;
            _x.joinDateTime = joinDateTime;
            _x.leaveDateTime = leaveDateTime;
            return _x;
        }
    }

    private AttendanceInterval _copy() {
        AttendanceInterval _x = new AttendanceInterval();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.durationInSeconds = durationInSeconds;
        _x.joinDateTime = joinDateTime;
        _x.leaveDateTime = leaveDateTime;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AttendanceInterval[");
        b.append("durationInSeconds=");
        b.append(this.durationInSeconds);
        b.append(", ");
        b.append("joinDateTime=");
        b.append(this.joinDateTime);
        b.append(", ");
        b.append("leaveDateTime=");
        b.append(this.leaveDateTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
