package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "attackSimulationUser", 
    "userTrainings"})
@JsonInclude(Include.NON_NULL)
public class AttackSimulationTrainingUserCoverage implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("attackSimulationUser")
    protected AttackSimulationUser attackSimulationUser;

    @JsonProperty("userTrainings")
    protected List<UserTrainingStatusInfo> userTrainings;

    @JsonProperty("userTrainings@nextLink")
    protected String userTrainingsNextLink;

    protected AttackSimulationTrainingUserCoverage() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.attackSimulationTrainingUserCoverage";
    }

    @Property(name="attackSimulationUser")
    @JsonIgnore
    public Optional<AttackSimulationUser> getAttackSimulationUser() {
        return Optional.ofNullable(attackSimulationUser);
    }

    public AttackSimulationTrainingUserCoverage withAttackSimulationUser(AttackSimulationUser attackSimulationUser) {
        AttackSimulationTrainingUserCoverage _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.attackSimulationTrainingUserCoverage");
        _x.attackSimulationUser = attackSimulationUser;
        return _x;
    }

    @Property(name="userTrainings")
    @JsonIgnore
    public CollectionPage<UserTrainingStatusInfo> getUserTrainings() {
        return new CollectionPage<UserTrainingStatusInfo>(contextPath, UserTrainingStatusInfo.class, this.userTrainings, Optional.ofNullable(userTrainingsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="userTrainings")
    @JsonIgnore
    public CollectionPage<UserTrainingStatusInfo> getUserTrainings(HttpRequestOptions options) {
        return new CollectionPage<UserTrainingStatusInfo>(contextPath, UserTrainingStatusInfo.class, this.userTrainings, Optional.ofNullable(userTrainingsNextLink), Collections.emptyList(), options);
    }

    public AttackSimulationTrainingUserCoverage withUnmappedField(String name, Object value) {
        AttackSimulationTrainingUserCoverage _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private AttackSimulationUser attackSimulationUser;
        private List<UserTrainingStatusInfo> userTrainings;
        private String userTrainingsNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder attackSimulationUser(AttackSimulationUser attackSimulationUser) {
            this.attackSimulationUser = attackSimulationUser;
            this.changedFields = changedFields.add("attackSimulationUser");
            return this;
        }

        public Builder userTrainings(List<UserTrainingStatusInfo> userTrainings) {
            this.userTrainings = userTrainings;
            this.changedFields = changedFields.add("userTrainings");
            return this;
        }

        public Builder userTrainings(UserTrainingStatusInfo... userTrainings) {
            return userTrainings(Arrays.asList(userTrainings));
        }

        public Builder userTrainingsNextLink(String userTrainingsNextLink) {
            this.userTrainingsNextLink = userTrainingsNextLink;
            this.changedFields = changedFields.add("userTrainings");
            return this;
        }

        public AttackSimulationTrainingUserCoverage build() {
            AttackSimulationTrainingUserCoverage _x = new AttackSimulationTrainingUserCoverage();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.attackSimulationTrainingUserCoverage";
            _x.attackSimulationUser = attackSimulationUser;
            _x.userTrainings = userTrainings;
            _x.userTrainingsNextLink = userTrainingsNextLink;
            return _x;
        }
    }

    private AttackSimulationTrainingUserCoverage _copy() {
        AttackSimulationTrainingUserCoverage _x = new AttackSimulationTrainingUserCoverage();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.attackSimulationUser = attackSimulationUser;
        _x.userTrainings = userTrainings;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AttackSimulationTrainingUserCoverage[");
        b.append("attackSimulationUser=");
        b.append(this.attackSimulationUser);
        b.append(", ");
        b.append("userTrainings=");
        b.append(this.userTrainings);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
