package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "attackSimulationUser", 
    "clickCount", 
    "compromisedCount", 
    "latestSimulationDateTime", 
    "simulationCount"})
@JsonInclude(Include.NON_NULL)
public class AttackSimulationSimulationUserCoverage implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("attackSimulationUser")
    protected AttackSimulationUser attackSimulationUser;

    @JsonProperty("clickCount")
    protected Integer clickCount;

    @JsonProperty("compromisedCount")
    protected Integer compromisedCount;

    @JsonProperty("latestSimulationDateTime")
    protected OffsetDateTime latestSimulationDateTime;

    @JsonProperty("simulationCount")
    protected Integer simulationCount;

    protected AttackSimulationSimulationUserCoverage() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.attackSimulationSimulationUserCoverage";
    }

    @Property(name="attackSimulationUser")
    @JsonIgnore
    public Optional<AttackSimulationUser> getAttackSimulationUser() {
        return Optional.ofNullable(attackSimulationUser);
    }

    public AttackSimulationSimulationUserCoverage withAttackSimulationUser(AttackSimulationUser attackSimulationUser) {
        AttackSimulationSimulationUserCoverage _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.attackSimulationSimulationUserCoverage");
        _x.attackSimulationUser = attackSimulationUser;
        return _x;
    }

    @Property(name="clickCount")
    @JsonIgnore
    public Optional<Integer> getClickCount() {
        return Optional.ofNullable(clickCount);
    }

    public AttackSimulationSimulationUserCoverage withClickCount(Integer clickCount) {
        AttackSimulationSimulationUserCoverage _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.attackSimulationSimulationUserCoverage");
        _x.clickCount = clickCount;
        return _x;
    }

    @Property(name="compromisedCount")
    @JsonIgnore
    public Optional<Integer> getCompromisedCount() {
        return Optional.ofNullable(compromisedCount);
    }

    public AttackSimulationSimulationUserCoverage withCompromisedCount(Integer compromisedCount) {
        AttackSimulationSimulationUserCoverage _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.attackSimulationSimulationUserCoverage");
        _x.compromisedCount = compromisedCount;
        return _x;
    }

    @Property(name="latestSimulationDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLatestSimulationDateTime() {
        return Optional.ofNullable(latestSimulationDateTime);
    }

    public AttackSimulationSimulationUserCoverage withLatestSimulationDateTime(OffsetDateTime latestSimulationDateTime) {
        AttackSimulationSimulationUserCoverage _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.attackSimulationSimulationUserCoverage");
        _x.latestSimulationDateTime = latestSimulationDateTime;
        return _x;
    }

    @Property(name="simulationCount")
    @JsonIgnore
    public Optional<Integer> getSimulationCount() {
        return Optional.ofNullable(simulationCount);
    }

    public AttackSimulationSimulationUserCoverage withSimulationCount(Integer simulationCount) {
        AttackSimulationSimulationUserCoverage _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.attackSimulationSimulationUserCoverage");
        _x.simulationCount = simulationCount;
        return _x;
    }

    public AttackSimulationSimulationUserCoverage withUnmappedField(String name, Object value) {
        AttackSimulationSimulationUserCoverage _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private AttackSimulationUser attackSimulationUser;
        private Integer clickCount;
        private Integer compromisedCount;
        private OffsetDateTime latestSimulationDateTime;
        private Integer simulationCount;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder attackSimulationUser(AttackSimulationUser attackSimulationUser) {
            this.attackSimulationUser = attackSimulationUser;
            this.changedFields = changedFields.add("attackSimulationUser");
            return this;
        }

        public Builder clickCount(Integer clickCount) {
            this.clickCount = clickCount;
            this.changedFields = changedFields.add("clickCount");
            return this;
        }

        public Builder compromisedCount(Integer compromisedCount) {
            this.compromisedCount = compromisedCount;
            this.changedFields = changedFields.add("compromisedCount");
            return this;
        }

        public Builder latestSimulationDateTime(OffsetDateTime latestSimulationDateTime) {
            this.latestSimulationDateTime = latestSimulationDateTime;
            this.changedFields = changedFields.add("latestSimulationDateTime");
            return this;
        }

        public Builder simulationCount(Integer simulationCount) {
            this.simulationCount = simulationCount;
            this.changedFields = changedFields.add("simulationCount");
            return this;
        }

        public AttackSimulationSimulationUserCoverage build() {
            AttackSimulationSimulationUserCoverage _x = new AttackSimulationSimulationUserCoverage();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.attackSimulationSimulationUserCoverage";
            _x.attackSimulationUser = attackSimulationUser;
            _x.clickCount = clickCount;
            _x.compromisedCount = compromisedCount;
            _x.latestSimulationDateTime = latestSimulationDateTime;
            _x.simulationCount = simulationCount;
            return _x;
        }
    }

    private AttackSimulationSimulationUserCoverage _copy() {
        AttackSimulationSimulationUserCoverage _x = new AttackSimulationSimulationUserCoverage();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.attackSimulationUser = attackSimulationUser;
        _x.clickCount = clickCount;
        _x.compromisedCount = compromisedCount;
        _x.latestSimulationDateTime = latestSimulationDateTime;
        _x.simulationCount = simulationCount;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AttackSimulationSimulationUserCoverage[");
        b.append("attackSimulationUser=");
        b.append(this.attackSimulationUser);
        b.append(", ");
        b.append("clickCount=");
        b.append(this.clickCount);
        b.append(", ");
        b.append("compromisedCount=");
        b.append(this.compromisedCount);
        b.append(", ");
        b.append("latestSimulationDateTime=");
        b.append(this.latestSimulationDateTime);
        b.append(", ");
        b.append("simulationCount=");
        b.append(this.simulationCount);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
