package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "attackSimulationUser", 
    "repeatOffenceCount"})
@JsonInclude(Include.NON_NULL)
public class AttackSimulationRepeatOffender implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("attackSimulationUser")
    protected AttackSimulationUser attackSimulationUser;

    @JsonProperty("repeatOffenceCount")
    protected Integer repeatOffenceCount;

    protected AttackSimulationRepeatOffender() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.attackSimulationRepeatOffender";
    }

    @Property(name="attackSimulationUser")
    @JsonIgnore
    public Optional<AttackSimulationUser> getAttackSimulationUser() {
        return Optional.ofNullable(attackSimulationUser);
    }

    public AttackSimulationRepeatOffender withAttackSimulationUser(AttackSimulationUser attackSimulationUser) {
        AttackSimulationRepeatOffender _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.attackSimulationRepeatOffender");
        _x.attackSimulationUser = attackSimulationUser;
        return _x;
    }

    @Property(name="repeatOffenceCount")
    @JsonIgnore
    public Optional<Integer> getRepeatOffenceCount() {
        return Optional.ofNullable(repeatOffenceCount);
    }

    public AttackSimulationRepeatOffender withRepeatOffenceCount(Integer repeatOffenceCount) {
        AttackSimulationRepeatOffender _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.attackSimulationRepeatOffender");
        _x.repeatOffenceCount = repeatOffenceCount;
        return _x;
    }

    public AttackSimulationRepeatOffender withUnmappedField(String name, Object value) {
        AttackSimulationRepeatOffender _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private AttackSimulationUser attackSimulationUser;
        private Integer repeatOffenceCount;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder attackSimulationUser(AttackSimulationUser attackSimulationUser) {
            this.attackSimulationUser = attackSimulationUser;
            this.changedFields = changedFields.add("attackSimulationUser");
            return this;
        }

        public Builder repeatOffenceCount(Integer repeatOffenceCount) {
            this.repeatOffenceCount = repeatOffenceCount;
            this.changedFields = changedFields.add("repeatOffenceCount");
            return this;
        }

        public AttackSimulationRepeatOffender build() {
            AttackSimulationRepeatOffender _x = new AttackSimulationRepeatOffender();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.attackSimulationRepeatOffender";
            _x.attackSimulationUser = attackSimulationUser;
            _x.repeatOffenceCount = repeatOffenceCount;
            return _x;
        }
    }

    private AttackSimulationRepeatOffender _copy() {
        AttackSimulationRepeatOffender _x = new AttackSimulationRepeatOffender();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.attackSimulationUser = attackSimulationUser;
        _x.repeatOffenceCount = repeatOffenceCount;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AttackSimulationRepeatOffender[");
        b.append("attackSimulationUser=");
        b.append(this.attackSimulationUser);
        b.append(", ");
        b.append("repeatOffenceCount=");
        b.append(this.repeatOffenceCount);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
