package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.AttachmentType;

@JsonPropertyOrder({
    "@odata.type", 
    "attachmentType", 
    "contentId", 
    "contentType", 
    "isInline", 
    "name", 
    "size"})
@JsonInclude(Include.NON_NULL)
public class AttachmentItem implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("attachmentType")
    protected AttachmentType attachmentType;

    @JsonProperty("contentId")
    protected String contentId;

    @JsonProperty("contentType")
    protected String contentType;

    @JsonProperty("isInline")
    protected Boolean isInline;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("size")
    protected Long size;

    protected AttachmentItem() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.attachmentItem";
    }

    @Property(name="attachmentType")
    @JsonIgnore
    public Optional<AttachmentType> getAttachmentType() {
        return Optional.ofNullable(attachmentType);
    }

    public AttachmentItem withAttachmentType(AttachmentType attachmentType) {
        AttachmentItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.attachmentItem");
        _x.attachmentType = attachmentType;
        return _x;
    }

    @Property(name="contentId")
    @JsonIgnore
    public Optional<String> getContentId() {
        return Optional.ofNullable(contentId);
    }

    public AttachmentItem withContentId(String contentId) {
        AttachmentItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.attachmentItem");
        _x.contentId = contentId;
        return _x;
    }

    @Property(name="contentType")
    @JsonIgnore
    public Optional<String> getContentType() {
        return Optional.ofNullable(contentType);
    }

    public AttachmentItem withContentType(String contentType) {
        AttachmentItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.attachmentItem");
        _x.contentType = contentType;
        return _x;
    }

    @Property(name="isInline")
    @JsonIgnore
    public Optional<Boolean> getIsInline() {
        return Optional.ofNullable(isInline);
    }

    public AttachmentItem withIsInline(Boolean isInline) {
        AttachmentItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.attachmentItem");
        _x.isInline = isInline;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public AttachmentItem withName(String name) {
        AttachmentItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.attachmentItem");
        _x.name = name;
        return _x;
    }

    @Property(name="size")
    @JsonIgnore
    public Optional<Long> getSize() {
        return Optional.ofNullable(size);
    }

    public AttachmentItem withSize(Long size) {
        AttachmentItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.attachmentItem");
        _x.size = size;
        return _x;
    }

    public AttachmentItem withUnmappedField(String name, Object value) {
        AttachmentItem _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private AttachmentType attachmentType;
        private String contentId;
        private String contentType;
        private Boolean isInline;
        private String name;
        private Long size;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder attachmentType(AttachmentType attachmentType) {
            this.attachmentType = attachmentType;
            this.changedFields = changedFields.add("attachmentType");
            return this;
        }

        public Builder contentId(String contentId) {
            this.contentId = contentId;
            this.changedFields = changedFields.add("contentId");
            return this;
        }

        public Builder contentType(String contentType) {
            this.contentType = contentType;
            this.changedFields = changedFields.add("contentType");
            return this;
        }

        public Builder isInline(Boolean isInline) {
            this.isInline = isInline;
            this.changedFields = changedFields.add("isInline");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder size(Long size) {
            this.size = size;
            this.changedFields = changedFields.add("size");
            return this;
        }

        public AttachmentItem build() {
            AttachmentItem _x = new AttachmentItem();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.attachmentItem";
            _x.attachmentType = attachmentType;
            _x.contentId = contentId;
            _x.contentType = contentType;
            _x.isInline = isInline;
            _x.name = name;
            _x.size = size;
            return _x;
        }
    }

    private AttachmentItem _copy() {
        AttachmentItem _x = new AttachmentItem();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.attachmentType = attachmentType;
        _x.contentId = contentId;
        _x.contentType = contentType;
        _x.isInline = isInline;
        _x.name = name;
        _x.size = size;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AttachmentItem[");
        b.append("attachmentType=");
        b.append(this.attachmentType);
        b.append(", ");
        b.append("contentId=");
        b.append(this.contentId);
        b.append(", ");
        b.append("contentType=");
        b.append(this.contentType);
        b.append(", ");
        b.append("isInline=");
        b.append(this.isInline);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("size=");
        b.append(this.size);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
