package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "order"})
@JsonInclude(Include.NON_NULL)
public class AssignmentOrder implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("order")
    protected List<String> order;

    @JsonProperty("order@nextLink")
    protected String orderNextLink;

    protected AssignmentOrder() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.assignmentOrder";
    }

    @Property(name="order")
    @JsonIgnore
    public CollectionPage<String> getOrder() {
        return new CollectionPage<String>(contextPath, String.class, this.order, Optional.ofNullable(orderNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="order")
    @JsonIgnore
    public CollectionPage<String> getOrder(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.order, Optional.ofNullable(orderNextLink), Collections.emptyList(), options);
    }

    public AssignmentOrder withUnmappedField(String name, Object value) {
        AssignmentOrder _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<String> order;
        private String orderNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder order(List<String> order) {
            this.order = order;
            this.changedFields = changedFields.add("order");
            return this;
        }

        public Builder order(String... order) {
            return order(Arrays.asList(order));
        }

        public Builder orderNextLink(String orderNextLink) {
            this.orderNextLink = orderNextLink;
            this.changedFields = changedFields.add("order");
            return this;
        }

        public AssignmentOrder build() {
            AssignmentOrder _x = new AssignmentOrder();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.assignmentOrder";
            _x.order = order;
            _x.orderNextLink = orderNextLink;
            return _x;
        }
    }

    private AssignmentOrder _copy() {
        AssignmentOrder _x = new AssignmentOrder();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.order = order;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AssignmentOrder[");
        b.append("order=");
        b.append(this.order);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
