package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;


/**
 * <i>“Represent status details for device and payload and all associated applied
 * filters.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "deviceProperties", 
    "evalutionSummaries", 
    "managedDeviceId", 
    "payloadId", 
    "userId"})
@JsonInclude(Include.NON_NULL)
public class AssignmentFilterStatusDetails implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("deviceProperties")
    protected List<KeyValuePair> deviceProperties;

    @JsonProperty("deviceProperties@nextLink")
    protected String devicePropertiesNextLink;

    @JsonProperty("evalutionSummaries")
    protected List<AssignmentFilterEvaluationSummary> evalutionSummaries;

    @JsonProperty("evalutionSummaries@nextLink")
    protected String evalutionSummariesNextLink;

    @JsonProperty("managedDeviceId")
    protected String managedDeviceId;

    @JsonProperty("payloadId")
    protected String payloadId;

    @JsonProperty("userId")
    protected String userId;

    protected AssignmentFilterStatusDetails() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.assignmentFilterStatusDetails";
    }

    /**
     * <i>“Device properties used for filter evaluation during device check-in time.”</i>
     * 
     * @return property deviceProperties
     */
    @Property(name="deviceProperties")
    @JsonIgnore
    public CollectionPage<KeyValuePair> getDeviceProperties() {
        return new CollectionPage<KeyValuePair>(contextPath, KeyValuePair.class, this.deviceProperties, Optional.ofNullable(devicePropertiesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Device properties used for filter evaluation during device check-in time.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property deviceProperties
     */
    @Property(name="deviceProperties")
    @JsonIgnore
    public CollectionPage<KeyValuePair> getDeviceProperties(HttpRequestOptions options) {
        return new CollectionPage<KeyValuePair>(contextPath, KeyValuePair.class, this.deviceProperties, Optional.ofNullable(devicePropertiesNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Evaluation result summaries for each filter associated to device and payload”</i>
     * 
     * @return property evalutionSummaries
     */
    @Property(name="evalutionSummaries")
    @JsonIgnore
    public CollectionPage<AssignmentFilterEvaluationSummary> getEvalutionSummaries() {
        return new CollectionPage<AssignmentFilterEvaluationSummary>(contextPath, AssignmentFilterEvaluationSummary.class, this.evalutionSummaries, Optional.ofNullable(evalutionSummariesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Evaluation result summaries for each filter associated to device and payload”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property evalutionSummaries
     */
    @Property(name="evalutionSummaries")
    @JsonIgnore
    public CollectionPage<AssignmentFilterEvaluationSummary> getEvalutionSummaries(HttpRequestOptions options) {
        return new CollectionPage<AssignmentFilterEvaluationSummary>(contextPath, AssignmentFilterEvaluationSummary.class, this.evalutionSummaries, Optional.ofNullable(evalutionSummariesNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Unique identifier for the device object.”</i>
     * 
     * @return property managedDeviceId
     */
    @Property(name="managedDeviceId")
    @JsonIgnore
    public Optional<String> getManagedDeviceId() {
        return Optional.ofNullable(managedDeviceId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code managedDeviceId}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Unique identifier for the device object.”</i>
     * 
     * @param managedDeviceId
     *            new value of {@code managedDeviceId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code managedDeviceId} field changed
     */
    public AssignmentFilterStatusDetails withManagedDeviceId(String managedDeviceId) {
        AssignmentFilterStatusDetails _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.assignmentFilterStatusDetails");
        _x.managedDeviceId = managedDeviceId;
        return _x;
    }

    /**
     * <i>“Unique identifier for payload object.”</i>
     * 
     * @return property payloadId
     */
    @Property(name="payloadId")
    @JsonIgnore
    public Optional<String> getPayloadId() {
        return Optional.ofNullable(payloadId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code payloadId} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Unique identifier for payload object.”</i>
     * 
     * @param payloadId
     *            new value of {@code payloadId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code payloadId} field changed
     */
    public AssignmentFilterStatusDetails withPayloadId(String payloadId) {
        AssignmentFilterStatusDetails _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.assignmentFilterStatusDetails");
        _x.payloadId = payloadId;
        return _x;
    }

    /**
     * <i>“Unique identifier for UserId object. Can be null”</i>
     * 
     * @return property userId
     */
    @Property(name="userId")
    @JsonIgnore
    public Optional<String> getUserId() {
        return Optional.ofNullable(userId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code userId} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Unique identifier for UserId object. Can be null”</i>
     * 
     * @param userId
     *            new value of {@code userId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userId} field changed
     */
    public AssignmentFilterStatusDetails withUserId(String userId) {
        AssignmentFilterStatusDetails _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.assignmentFilterStatusDetails");
        _x.userId = userId;
        return _x;
    }

    public AssignmentFilterStatusDetails withUnmappedField(String name, Object value) {
        AssignmentFilterStatusDetails _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<KeyValuePair> deviceProperties;
        private String devicePropertiesNextLink;
        private List<AssignmentFilterEvaluationSummary> evalutionSummaries;
        private String evalutionSummariesNextLink;
        private String managedDeviceId;
        private String payloadId;
        private String userId;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Device properties used for filter evaluation during device check-in time.”</i>
         * 
         * @param deviceProperties
         *            value of {@code deviceProperties} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceProperties(List<KeyValuePair> deviceProperties) {
            this.deviceProperties = deviceProperties;
            this.changedFields = changedFields.add("deviceProperties");
            return this;
        }

        /**
         * <i>“Device properties used for filter evaluation during device check-in time.”</i>
         * 
         * @param deviceProperties
         *            value of {@code deviceProperties} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceProperties(KeyValuePair... deviceProperties) {
            return deviceProperties(Arrays.asList(deviceProperties));
        }

        /**
         * <i>“Device properties used for filter evaluation during device check-in time.”</i>
         * 
         * @param devicePropertiesNextLink
         *            value of {@code deviceProperties@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder devicePropertiesNextLink(String devicePropertiesNextLink) {
            this.devicePropertiesNextLink = devicePropertiesNextLink;
            this.changedFields = changedFields.add("deviceProperties");
            return this;
        }

        /**
         * <i>“Evaluation result summaries for each filter associated to device and payload”</i>
         * 
         * @param evalutionSummaries
         *            value of {@code evalutionSummaries} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder evalutionSummaries(List<AssignmentFilterEvaluationSummary> evalutionSummaries) {
            this.evalutionSummaries = evalutionSummaries;
            this.changedFields = changedFields.add("evalutionSummaries");
            return this;
        }

        /**
         * <i>“Evaluation result summaries for each filter associated to device and payload”</i>
         * 
         * @param evalutionSummaries
         *            value of {@code evalutionSummaries} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder evalutionSummaries(AssignmentFilterEvaluationSummary... evalutionSummaries) {
            return evalutionSummaries(Arrays.asList(evalutionSummaries));
        }

        /**
         * <i>“Evaluation result summaries for each filter associated to device and payload”</i>
         * 
         * @param evalutionSummariesNextLink
         *            value of {@code evalutionSummaries@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder evalutionSummariesNextLink(String evalutionSummariesNextLink) {
            this.evalutionSummariesNextLink = evalutionSummariesNextLink;
            this.changedFields = changedFields.add("evalutionSummaries");
            return this;
        }

        /**
         * <i>“Unique identifier for the device object.”</i>
         * 
         * @param managedDeviceId
         *            value of {@code managedDeviceId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder managedDeviceId(String managedDeviceId) {
            this.managedDeviceId = managedDeviceId;
            this.changedFields = changedFields.add("managedDeviceId");
            return this;
        }

        /**
         * <i>“Unique identifier for payload object.”</i>
         * 
         * @param payloadId
         *            value of {@code payloadId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder payloadId(String payloadId) {
            this.payloadId = payloadId;
            this.changedFields = changedFields.add("payloadId");
            return this;
        }

        /**
         * <i>“Unique identifier for UserId object. Can be null”</i>
         * 
         * @param userId
         *            value of {@code userId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userId(String userId) {
            this.userId = userId;
            this.changedFields = changedFields.add("userId");
            return this;
        }

        public AssignmentFilterStatusDetails build() {
            AssignmentFilterStatusDetails _x = new AssignmentFilterStatusDetails();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.assignmentFilterStatusDetails";
            _x.deviceProperties = deviceProperties;
            _x.devicePropertiesNextLink = devicePropertiesNextLink;
            _x.evalutionSummaries = evalutionSummaries;
            _x.evalutionSummariesNextLink = evalutionSummariesNextLink;
            _x.managedDeviceId = managedDeviceId;
            _x.payloadId = payloadId;
            _x.userId = userId;
            return _x;
        }
    }

    private AssignmentFilterStatusDetails _copy() {
        AssignmentFilterStatusDetails _x = new AssignmentFilterStatusDetails();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.deviceProperties = deviceProperties;
        _x.evalutionSummaries = evalutionSummaries;
        _x.managedDeviceId = managedDeviceId;
        _x.payloadId = payloadId;
        _x.userId = userId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AssignmentFilterStatusDetails[");
        b.append("deviceProperties=");
        b.append(this.deviceProperties);
        b.append(", ");
        b.append("evalutionSummaries=");
        b.append(this.evalutionSummaries);
        b.append(", ");
        b.append("managedDeviceId=");
        b.append(this.managedDeviceId);
        b.append(", ");
        b.append("payloadId=");
        b.append(this.payloadId);
        b.append(", ");
        b.append("userId=");
        b.append(this.userId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
