package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.DevicePlatformType;


/**
 * <i>“Request for assignment filter evaluation for devices.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "orderBy", 
    "platform", 
    "rule", 
    "skip", 
    "top"})
@JsonInclude(Include.NON_NULL)
public class AssignmentFilterEvaluateRequest implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("orderBy")
    protected List<String> orderBy;

    @JsonProperty("orderBy@nextLink")
    protected String orderByNextLink;

    @JsonProperty("platform")
    protected DevicePlatformType platform;

    @JsonProperty("rule")
    protected String rule;

    @JsonProperty("skip")
    protected Integer skip;

    @JsonProperty("top")
    protected Integer top;

    protected AssignmentFilterEvaluateRequest() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.assignmentFilterEvaluateRequest";
    }

    /**
     * <i>“Order the devices should be sorted in. Default is ascending on device name.”</i>
     * 
     * @return property orderBy
     */
    @Property(name="orderBy")
    @JsonIgnore
    public CollectionPage<String> getOrderBy() {
        return new CollectionPage<String>(contextPath, String.class, this.orderBy, Optional.ofNullable(orderByNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Order the devices should be sorted in. Default is ascending on device name.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property orderBy
     */
    @Property(name="orderBy")
    @JsonIgnore
    public CollectionPage<String> getOrderBy(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.orderBy, Optional.ofNullable(orderByNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Platform type of the devices on which the Assignment Filter will be applicable.”</i>
     * 
     * @return property platform
     */
    @Property(name="platform")
    @JsonIgnore
    public Optional<DevicePlatformType> getPlatform() {
        return Optional.ofNullable(platform);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code platform} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Platform type of the devices on which the Assignment Filter will be applicable.”</i>
     * 
     * @param platform
     *            new value of {@code platform} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code platform} field changed
     */
    public AssignmentFilterEvaluateRequest withPlatform(DevicePlatformType platform) {
        AssignmentFilterEvaluateRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.assignmentFilterEvaluateRequest");
        _x.platform = platform;
        return _x;
    }

    /**
     * <i>“Rule definition of the Assignment Filter.”</i>
     * 
     * @return property rule
     */
    @Property(name="rule")
    @JsonIgnore
    public Optional<String> getRule() {
        return Optional.ofNullable(rule);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code rule} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Rule definition of the Assignment Filter.”</i>
     * 
     * @param rule
     *            new value of {@code rule} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code rule} field changed
     */
    public AssignmentFilterEvaluateRequest withRule(String rule) {
        AssignmentFilterEvaluateRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.assignmentFilterEvaluateRequest");
        _x.rule = rule;
        return _x;
    }

    /**
     * <i>“Number of records to skip. Default value is 0”</i>
     * 
     * @return property skip
     */
    @Property(name="skip")
    @JsonIgnore
    public Optional<Integer> getSkip() {
        return Optional.ofNullable(skip);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code skip} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Number of records to skip. Default value is 0”</i>
     * 
     * @param skip
     *            new value of {@code skip} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code skip} field changed
     */
    public AssignmentFilterEvaluateRequest withSkip(Integer skip) {
        AssignmentFilterEvaluateRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.assignmentFilterEvaluateRequest");
        _x.skip = skip;
        return _x;
    }

    /**
     * <i>“Limit of records per request. Default value is 100, if provided less than 0 or
     * greater than 100”</i>
     * 
     * @return property top
     */
    @Property(name="top")
    @JsonIgnore
    public Optional<Integer> getTop() {
        return Optional.ofNullable(top);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code top} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Limit of records per request. Default value is 100, if provided less than 0 or
     * greater than 100”</i>
     * 
     * @param top
     *            new value of {@code top} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code top} field changed
     */
    public AssignmentFilterEvaluateRequest withTop(Integer top) {
        AssignmentFilterEvaluateRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.assignmentFilterEvaluateRequest");
        _x.top = top;
        return _x;
    }

    public AssignmentFilterEvaluateRequest withUnmappedField(String name, Object value) {
        AssignmentFilterEvaluateRequest _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<String> orderBy;
        private String orderByNextLink;
        private DevicePlatformType platform;
        private String rule;
        private Integer skip;
        private Integer top;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Order the devices should be sorted in. Default is ascending on device name.”</i>
         * 
         * @param orderBy
         *            value of {@code orderBy} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder orderBy(List<String> orderBy) {
            this.orderBy = orderBy;
            this.changedFields = changedFields.add("orderBy");
            return this;
        }

        /**
         * <i>“Order the devices should be sorted in. Default is ascending on device name.”</i>
         * 
         * @param orderBy
         *            value of {@code orderBy} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder orderBy(String... orderBy) {
            return orderBy(Arrays.asList(orderBy));
        }

        /**
         * <i>“Order the devices should be sorted in. Default is ascending on device name.”</i>
         * 
         * @param orderByNextLink
         *            value of {@code orderBy@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder orderByNextLink(String orderByNextLink) {
            this.orderByNextLink = orderByNextLink;
            this.changedFields = changedFields.add("orderBy");
            return this;
        }

        /**
         * <i>“Platform type of the devices on which the Assignment Filter will be applicable.”</i>
         * 
         * @param platform
         *            value of {@code platform} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder platform(DevicePlatformType platform) {
            this.platform = platform;
            this.changedFields = changedFields.add("platform");
            return this;
        }

        /**
         * <i>“Rule definition of the Assignment Filter.”</i>
         * 
         * @param rule
         *            value of {@code rule} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder rule(String rule) {
            this.rule = rule;
            this.changedFields = changedFields.add("rule");
            return this;
        }

        /**
         * <i>“Number of records to skip. Default value is 0”</i>
         * 
         * @param skip
         *            value of {@code skip} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder skip(Integer skip) {
            this.skip = skip;
            this.changedFields = changedFields.add("skip");
            return this;
        }

        /**
         * <i>“Limit of records per request. Default value is 100, if provided less than 0 or
         * greater than 100”</i>
         * 
         * @param top
         *            value of {@code top} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder top(Integer top) {
            this.top = top;
            this.changedFields = changedFields.add("top");
            return this;
        }

        public AssignmentFilterEvaluateRequest build() {
            AssignmentFilterEvaluateRequest _x = new AssignmentFilterEvaluateRequest();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.assignmentFilterEvaluateRequest";
            _x.orderBy = orderBy;
            _x.orderByNextLink = orderByNextLink;
            _x.platform = platform;
            _x.rule = rule;
            _x.skip = skip;
            _x.top = top;
            return _x;
        }
    }

    private AssignmentFilterEvaluateRequest _copy() {
        AssignmentFilterEvaluateRequest _x = new AssignmentFilterEvaluateRequest();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.orderBy = orderBy;
        _x.platform = platform;
        _x.rule = rule;
        _x.skip = skip;
        _x.top = top;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AssignmentFilterEvaluateRequest[");
        b.append("orderBy=");
        b.append(this.orderBy);
        b.append(", ");
        b.append("platform=");
        b.append(this.platform);
        b.append(", ");
        b.append("rule=");
        b.append(this.rule);
        b.append(", ");
        b.append("skip=");
        b.append(this.skip);
        b.append(", ");
        b.append("top=");
        b.append(this.top);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
