package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.UUID;

@JsonPropertyOrder({
    "@odata.type", 
    "assignedDateTime", 
    "capabilityStatus", 
    "service", 
    "servicePlanId"})
@JsonInclude(Include.NON_NULL)
public class AssignedPlan implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("assignedDateTime")
    protected OffsetDateTime assignedDateTime;

    @JsonProperty("capabilityStatus")
    protected String capabilityStatus;

    @JsonProperty("service")
    protected String service;

    @JsonProperty("servicePlanId")
    protected UUID servicePlanId;

    protected AssignedPlan() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.assignedPlan";
    }

    @Property(name="assignedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getAssignedDateTime() {
        return Optional.ofNullable(assignedDateTime);
    }

    public AssignedPlan withAssignedDateTime(OffsetDateTime assignedDateTime) {
        AssignedPlan _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.assignedPlan");
        _x.assignedDateTime = assignedDateTime;
        return _x;
    }

    @Property(name="capabilityStatus")
    @JsonIgnore
    public Optional<String> getCapabilityStatus() {
        return Optional.ofNullable(capabilityStatus);
    }

    public AssignedPlan withCapabilityStatus(String capabilityStatus) {
        AssignedPlan _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.assignedPlan");
        _x.capabilityStatus = capabilityStatus;
        return _x;
    }

    @Property(name="service")
    @JsonIgnore
    public Optional<String> getService() {
        return Optional.ofNullable(service);
    }

    public AssignedPlan withService(String service) {
        AssignedPlan _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.assignedPlan");
        _x.service = service;
        return _x;
    }

    @Property(name="servicePlanId")
    @JsonIgnore
    public Optional<UUID> getServicePlanId() {
        return Optional.ofNullable(servicePlanId);
    }

    public AssignedPlan withServicePlanId(UUID servicePlanId) {
        AssignedPlan _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.assignedPlan");
        _x.servicePlanId = servicePlanId;
        return _x;
    }

    public AssignedPlan withUnmappedField(String name, Object value) {
        AssignedPlan _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private OffsetDateTime assignedDateTime;
        private String capabilityStatus;
        private String service;
        private UUID servicePlanId;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder assignedDateTime(OffsetDateTime assignedDateTime) {
            this.assignedDateTime = assignedDateTime;
            this.changedFields = changedFields.add("assignedDateTime");
            return this;
        }

        public Builder capabilityStatus(String capabilityStatus) {
            this.capabilityStatus = capabilityStatus;
            this.changedFields = changedFields.add("capabilityStatus");
            return this;
        }

        public Builder service(String service) {
            this.service = service;
            this.changedFields = changedFields.add("service");
            return this;
        }

        public Builder servicePlanId(UUID servicePlanId) {
            this.servicePlanId = servicePlanId;
            this.changedFields = changedFields.add("servicePlanId");
            return this;
        }

        public AssignedPlan build() {
            AssignedPlan _x = new AssignedPlan();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.assignedPlan";
            _x.assignedDateTime = assignedDateTime;
            _x.capabilityStatus = capabilityStatus;
            _x.service = service;
            _x.servicePlanId = servicePlanId;
            return _x;
        }
    }

    private AssignedPlan _copy() {
        AssignedPlan _x = new AssignedPlan();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.assignedDateTime = assignedDateTime;
        _x.capabilityStatus = capabilityStatus;
        _x.service = service;
        _x.servicePlanId = servicePlanId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AssignedPlan[");
        b.append("assignedDateTime=");
        b.append(this.assignedDateTime);
        b.append(", ");
        b.append("capabilityStatus=");
        b.append(this.capabilityStatus);
        b.append(", ");
        b.append("service=");
        b.append(this.service);
        b.append(", ");
        b.append("servicePlanId=");
        b.append(this.servicePlanId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
