package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "approvalMode", 
    "approvalStages", 
    "isApprovalRequired", 
    "isApprovalRequiredForExtension", 
    "isRequestorJustificationRequired"})
@JsonInclude(Include.NON_NULL)
public class ApprovalSettings implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("approvalMode")
    protected String approvalMode;

    @JsonProperty("approvalStages")
    protected List<ApprovalStage> approvalStages;

    @JsonProperty("approvalStages@nextLink")
    protected String approvalStagesNextLink;

    @JsonProperty("isApprovalRequired")
    protected Boolean isApprovalRequired;

    @JsonProperty("isApprovalRequiredForExtension")
    protected Boolean isApprovalRequiredForExtension;

    @JsonProperty("isRequestorJustificationRequired")
    protected Boolean isRequestorJustificationRequired;

    protected ApprovalSettings() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.approvalSettings";
    }

    @Property(name="approvalMode")
    @JsonIgnore
    public Optional<String> getApprovalMode() {
        return Optional.ofNullable(approvalMode);
    }

    public ApprovalSettings withApprovalMode(String approvalMode) {
        ApprovalSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.approvalSettings");
        _x.approvalMode = approvalMode;
        return _x;
    }

    @Property(name="approvalStages")
    @JsonIgnore
    public CollectionPage<ApprovalStage> getApprovalStages() {
        return new CollectionPage<ApprovalStage>(contextPath, ApprovalStage.class, this.approvalStages, Optional.ofNullable(approvalStagesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="approvalStages")
    @JsonIgnore
    public CollectionPage<ApprovalStage> getApprovalStages(HttpRequestOptions options) {
        return new CollectionPage<ApprovalStage>(contextPath, ApprovalStage.class, this.approvalStages, Optional.ofNullable(approvalStagesNextLink), Collections.emptyList(), options);
    }

    @Property(name="isApprovalRequired")
    @JsonIgnore
    public Optional<Boolean> getIsApprovalRequired() {
        return Optional.ofNullable(isApprovalRequired);
    }

    public ApprovalSettings withIsApprovalRequired(Boolean isApprovalRequired) {
        ApprovalSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.approvalSettings");
        _x.isApprovalRequired = isApprovalRequired;
        return _x;
    }

    @Property(name="isApprovalRequiredForExtension")
    @JsonIgnore
    public Optional<Boolean> getIsApprovalRequiredForExtension() {
        return Optional.ofNullable(isApprovalRequiredForExtension);
    }

    public ApprovalSettings withIsApprovalRequiredForExtension(Boolean isApprovalRequiredForExtension) {
        ApprovalSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.approvalSettings");
        _x.isApprovalRequiredForExtension = isApprovalRequiredForExtension;
        return _x;
    }

    @Property(name="isRequestorJustificationRequired")
    @JsonIgnore
    public Optional<Boolean> getIsRequestorJustificationRequired() {
        return Optional.ofNullable(isRequestorJustificationRequired);
    }

    public ApprovalSettings withIsRequestorJustificationRequired(Boolean isRequestorJustificationRequired) {
        ApprovalSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.approvalSettings");
        _x.isRequestorJustificationRequired = isRequestorJustificationRequired;
        return _x;
    }

    public ApprovalSettings withUnmappedField(String name, Object value) {
        ApprovalSettings _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String approvalMode;
        private List<ApprovalStage> approvalStages;
        private String approvalStagesNextLink;
        private Boolean isApprovalRequired;
        private Boolean isApprovalRequiredForExtension;
        private Boolean isRequestorJustificationRequired;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder approvalMode(String approvalMode) {
            this.approvalMode = approvalMode;
            this.changedFields = changedFields.add("approvalMode");
            return this;
        }

        public Builder approvalStages(List<ApprovalStage> approvalStages) {
            this.approvalStages = approvalStages;
            this.changedFields = changedFields.add("approvalStages");
            return this;
        }

        public Builder approvalStages(ApprovalStage... approvalStages) {
            return approvalStages(Arrays.asList(approvalStages));
        }

        public Builder approvalStagesNextLink(String approvalStagesNextLink) {
            this.approvalStagesNextLink = approvalStagesNextLink;
            this.changedFields = changedFields.add("approvalStages");
            return this;
        }

        public Builder isApprovalRequired(Boolean isApprovalRequired) {
            this.isApprovalRequired = isApprovalRequired;
            this.changedFields = changedFields.add("isApprovalRequired");
            return this;
        }

        public Builder isApprovalRequiredForExtension(Boolean isApprovalRequiredForExtension) {
            this.isApprovalRequiredForExtension = isApprovalRequiredForExtension;
            this.changedFields = changedFields.add("isApprovalRequiredForExtension");
            return this;
        }

        public Builder isRequestorJustificationRequired(Boolean isRequestorJustificationRequired) {
            this.isRequestorJustificationRequired = isRequestorJustificationRequired;
            this.changedFields = changedFields.add("isRequestorJustificationRequired");
            return this;
        }

        public ApprovalSettings build() {
            ApprovalSettings _x = new ApprovalSettings();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.approvalSettings";
            _x.approvalMode = approvalMode;
            _x.approvalStages = approvalStages;
            _x.approvalStagesNextLink = approvalStagesNextLink;
            _x.isApprovalRequired = isApprovalRequired;
            _x.isApprovalRequiredForExtension = isApprovalRequiredForExtension;
            _x.isRequestorJustificationRequired = isRequestorJustificationRequired;
            return _x;
        }
    }

    private ApprovalSettings _copy() {
        ApprovalSettings _x = new ApprovalSettings();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.approvalMode = approvalMode;
        _x.approvalStages = approvalStages;
        _x.isApprovalRequired = isApprovalRequired;
        _x.isApprovalRequiredForExtension = isApprovalRequiredForExtension;
        _x.isRequestorJustificationRequired = isRequestorJustificationRequired;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ApprovalSettings[");
        b.append("approvalMode=");
        b.append(this.approvalMode);
        b.append(", ");
        b.append("approvalStages=");
        b.append(this.approvalStages);
        b.append(", ");
        b.append("isApprovalRequired=");
        b.append(this.isApprovalRequired);
        b.append(", ");
        b.append("isApprovalRequiredForExtension=");
        b.append(this.isApprovalRequiredForExtension);
        b.append(", ");
        b.append("isRequestorJustificationRequired=");
        b.append(this.isRequestorJustificationRequired);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
