package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;

import odata.msgraph.client.beta.enums.ActionSource;

@JsonPropertyOrder({
    "@odata.type", 
    "actions", 
    "actionSource", 
    "label", 
    "responsibleSensitiveTypeIds"})
@JsonInclude(Include.NON_NULL)
public class ApplyLabelAction extends InformationProtectionAction implements ODataType {

    @JsonProperty("actions")
    protected List<InformationProtectionAction> actions;

    @JsonProperty("actions@nextLink")
    protected String actionsNextLink;

    @JsonProperty("actionSource")
    protected ActionSource actionSource;

    @JsonProperty("label")
    protected LabelDetails label;

    @JsonProperty("responsibleSensitiveTypeIds")
    protected List<UUID> responsibleSensitiveTypeIds;

    @JsonProperty("responsibleSensitiveTypeIds@nextLink")
    protected String responsibleSensitiveTypeIdsNextLink;

    protected ApplyLabelAction() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.applyLabelAction";
    }

    @Property(name="actions")
    @JsonIgnore
    public CollectionPage<InformationProtectionAction> getActions() {
        return new CollectionPage<InformationProtectionAction>(contextPath, InformationProtectionAction.class, this.actions, Optional.ofNullable(actionsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="actions")
    @JsonIgnore
    public CollectionPage<InformationProtectionAction> getActions(HttpRequestOptions options) {
        return new CollectionPage<InformationProtectionAction>(contextPath, InformationProtectionAction.class, this.actions, Optional.ofNullable(actionsNextLink), Collections.emptyList(), options);
    }

    @Property(name="actionSource")
    @JsonIgnore
    public Optional<ActionSource> getActionSource() {
        return Optional.ofNullable(actionSource);
    }

    public ApplyLabelAction withActionSource(ActionSource actionSource) {
        ApplyLabelAction _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.applyLabelAction");
        _x.actionSource = actionSource;
        return _x;
    }

    @Property(name="label")
    @JsonIgnore
    public Optional<LabelDetails> getLabel() {
        return Optional.ofNullable(label);
    }

    public ApplyLabelAction withLabel(LabelDetails label) {
        ApplyLabelAction _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.applyLabelAction");
        _x.label = label;
        return _x;
    }

    @Property(name="responsibleSensitiveTypeIds")
    @JsonIgnore
    public CollectionPage<UUID> getResponsibleSensitiveTypeIds() {
        return new CollectionPage<UUID>(contextPath, UUID.class, this.responsibleSensitiveTypeIds, Optional.ofNullable(responsibleSensitiveTypeIdsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="responsibleSensitiveTypeIds")
    @JsonIgnore
    public CollectionPage<UUID> getResponsibleSensitiveTypeIds(HttpRequestOptions options) {
        return new CollectionPage<UUID>(contextPath, UUID.class, this.responsibleSensitiveTypeIds, Optional.ofNullable(responsibleSensitiveTypeIdsNextLink), Collections.emptyList(), options);
    }

    public ApplyLabelAction withUnmappedField(String name, Object value) {
        ApplyLabelAction _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderApplyLabelAction() {
        return new Builder();
    }

    public static final class Builder {
        private List<InformationProtectionAction> actions;
        private String actionsNextLink;
        private ActionSource actionSource;
        private LabelDetails label;
        private List<UUID> responsibleSensitiveTypeIds;
        private String responsibleSensitiveTypeIdsNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder actions(List<InformationProtectionAction> actions) {
            this.actions = actions;
            this.changedFields = changedFields.add("actions");
            return this;
        }

        public Builder actions(InformationProtectionAction... actions) {
            return actions(Arrays.asList(actions));
        }

        public Builder actionsNextLink(String actionsNextLink) {
            this.actionsNextLink = actionsNextLink;
            this.changedFields = changedFields.add("actions");
            return this;
        }

        public Builder actionSource(ActionSource actionSource) {
            this.actionSource = actionSource;
            this.changedFields = changedFields.add("actionSource");
            return this;
        }

        public Builder label(LabelDetails label) {
            this.label = label;
            this.changedFields = changedFields.add("label");
            return this;
        }

        public Builder responsibleSensitiveTypeIds(List<UUID> responsibleSensitiveTypeIds) {
            this.responsibleSensitiveTypeIds = responsibleSensitiveTypeIds;
            this.changedFields = changedFields.add("responsibleSensitiveTypeIds");
            return this;
        }

        public Builder responsibleSensitiveTypeIds(UUID... responsibleSensitiveTypeIds) {
            return responsibleSensitiveTypeIds(Arrays.asList(responsibleSensitiveTypeIds));
        }

        public Builder responsibleSensitiveTypeIdsNextLink(String responsibleSensitiveTypeIdsNextLink) {
            this.responsibleSensitiveTypeIdsNextLink = responsibleSensitiveTypeIdsNextLink;
            this.changedFields = changedFields.add("responsibleSensitiveTypeIds");
            return this;
        }

        public ApplyLabelAction build() {
            ApplyLabelAction _x = new ApplyLabelAction();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.applyLabelAction";
            _x.actions = actions;
            _x.actionsNextLink = actionsNextLink;
            _x.actionSource = actionSource;
            _x.label = label;
            _x.responsibleSensitiveTypeIds = responsibleSensitiveTypeIds;
            _x.responsibleSensitiveTypeIdsNextLink = responsibleSensitiveTypeIdsNextLink;
            return _x;
        }
    }

    private ApplyLabelAction _copy() {
        ApplyLabelAction _x = new ApplyLabelAction();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.actions = actions;
        _x.actionSource = actionSource;
        _x.label = label;
        _x.responsibleSensitiveTypeIds = responsibleSensitiveTypeIds;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ApplyLabelAction[");
        b.append("actions=");
        b.append(this.actions);
        b.append(", ");
        b.append("actionSource=");
        b.append(this.actionSource);
        b.append(", ");
        b.append("label=");
        b.append(this.label);
        b.append(", ");
        b.append("responsibleSensitiveTypeIds=");
        b.append(this.responsibleSensitiveTypeIds);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
