package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.AppleUserInitiatedEnrollmentType;
import odata.msgraph.client.beta.enums.ManagedDeviceOwnerType;

@JsonPropertyOrder({
    "@odata.type", 
    "enrollmentType", 
    "ownerType"})
@JsonInclude(Include.NON_NULL)
public class AppleOwnerTypeEnrollmentType implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("enrollmentType")
    protected AppleUserInitiatedEnrollmentType enrollmentType;

    @JsonProperty("ownerType")
    protected ManagedDeviceOwnerType ownerType;

    protected AppleOwnerTypeEnrollmentType() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.appleOwnerTypeEnrollmentType";
    }

    /**
     * <i>“The enrollment type.”</i>
     * 
     * @return property enrollmentType
     */
    @Property(name="enrollmentType")
    @JsonIgnore
    public Optional<AppleUserInitiatedEnrollmentType> getEnrollmentType() {
        return Optional.ofNullable(enrollmentType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code enrollmentType}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The enrollment type.”</i>
     * 
     * @param enrollmentType
     *            new value of {@code enrollmentType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code enrollmentType} field changed
     */
    public AppleOwnerTypeEnrollmentType withEnrollmentType(AppleUserInitiatedEnrollmentType enrollmentType) {
        AppleOwnerTypeEnrollmentType _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appleOwnerTypeEnrollmentType");
        _x.enrollmentType = enrollmentType;
        return _x;
    }

    /**
     * <i>“The owner type.”</i>
     * 
     * @return property ownerType
     */
    @Property(name="ownerType")
    @JsonIgnore
    public Optional<ManagedDeviceOwnerType> getOwnerType() {
        return Optional.ofNullable(ownerType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code ownerType} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The owner type.”</i>
     * 
     * @param ownerType
     *            new value of {@code ownerType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code ownerType} field changed
     */
    public AppleOwnerTypeEnrollmentType withOwnerType(ManagedDeviceOwnerType ownerType) {
        AppleOwnerTypeEnrollmentType _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appleOwnerTypeEnrollmentType");
        _x.ownerType = ownerType;
        return _x;
    }

    public AppleOwnerTypeEnrollmentType withUnmappedField(String name, Object value) {
        AppleOwnerTypeEnrollmentType _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private AppleUserInitiatedEnrollmentType enrollmentType;
        private ManagedDeviceOwnerType ownerType;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“The enrollment type.”</i>
         * 
         * @param enrollmentType
         *            value of {@code enrollmentType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder enrollmentType(AppleUserInitiatedEnrollmentType enrollmentType) {
            this.enrollmentType = enrollmentType;
            this.changedFields = changedFields.add("enrollmentType");
            return this;
        }

        /**
         * <i>“The owner type.”</i>
         * 
         * @param ownerType
         *            value of {@code ownerType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder ownerType(ManagedDeviceOwnerType ownerType) {
            this.ownerType = ownerType;
            this.changedFields = changedFields.add("ownerType");
            return this;
        }

        public AppleOwnerTypeEnrollmentType build() {
            AppleOwnerTypeEnrollmentType _x = new AppleOwnerTypeEnrollmentType();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.appleOwnerTypeEnrollmentType";
            _x.enrollmentType = enrollmentType;
            _x.ownerType = ownerType;
            return _x;
        }
    }

    private AppleOwnerTypeEnrollmentType _copy() {
        AppleOwnerTypeEnrollmentType _x = new AppleOwnerTypeEnrollmentType();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.enrollmentType = enrollmentType;
        _x.ownerType = ownerType;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AppleOwnerTypeEnrollmentType[");
        b.append("enrollmentType=");
        b.append(this.enrollmentType);
        b.append(", ");
        b.append("ownerType=");
        b.append(this.ownerType);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
