package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;


/**
 * <i>“Represents an app in the list of managed Apple applications”</i>
 */@JsonPropertyOrder({
    "@odata.type"})
@JsonInclude(Include.NON_NULL)
public class AppleAppListItem extends AppListItem implements ODataType {

    protected AppleAppListItem() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.appleAppListItem";
    }

    public AppleAppListItem withUnmappedField(String name, Object value) {
        AppleAppListItem _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAppleAppListItem() {
        return new Builder();
    }

    public static final class Builder {
        private String appId;
        private String appStoreUrl;
        private String name;
        private String publisher;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder appId(String appId) {
            this.appId = appId;
            this.changedFields = changedFields.add("appId");
            return this;
        }

        public Builder appStoreUrl(String appStoreUrl) {
            this.appStoreUrl = appStoreUrl;
            this.changedFields = changedFields.add("appStoreUrl");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder publisher(String publisher) {
            this.publisher = publisher;
            this.changedFields = changedFields.add("publisher");
            return this;
        }

        public AppleAppListItem build() {
            AppleAppListItem _x = new AppleAppListItem();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.appleAppListItem";
            _x.appId = appId;
            _x.appStoreUrl = appStoreUrl;
            _x.name = name;
            _x.publisher = publisher;
            return _x;
        }
    }

    private AppleAppListItem _copy() {
        AppleAppListItem _x = new AppleAppListItem();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.appId = appId;
        _x.appStoreUrl = appStoreUrl;
        _x.name = name;
        _x.publisher = publisher;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AppleAppListItem[");
        b.append("appId=");
        b.append(this.appId);
        b.append(", ");
        b.append("appStoreUrl=");
        b.append(this.appStoreUrl);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("publisher=");
        b.append(this.publisher);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
