package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "data", 
    "version"})
@JsonInclude(Include.NON_NULL)
public class AppMetadata implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("data")
    protected List<AppMetadataEntry> data;

    @JsonProperty("data@nextLink")
    protected String dataNextLink;

    @JsonProperty("version")
    protected Integer version;

    protected AppMetadata() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.appMetadata";
    }

    @Property(name="data")
    @JsonIgnore
    public CollectionPage<AppMetadataEntry> getData() {
        return new CollectionPage<AppMetadataEntry>(contextPath, AppMetadataEntry.class, this.data, Optional.ofNullable(dataNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="data")
    @JsonIgnore
    public CollectionPage<AppMetadataEntry> getData(HttpRequestOptions options) {
        return new CollectionPage<AppMetadataEntry>(contextPath, AppMetadataEntry.class, this.data, Optional.ofNullable(dataNextLink), Collections.emptyList(), options);
    }

    @Property(name="version")
    @JsonIgnore
    public Optional<Integer> getVersion() {
        return Optional.ofNullable(version);
    }

    public AppMetadata withVersion(Integer version) {
        AppMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appMetadata");
        _x.version = version;
        return _x;
    }

    public AppMetadata withUnmappedField(String name, Object value) {
        AppMetadata _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<AppMetadataEntry> data;
        private String dataNextLink;
        private Integer version;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder data(List<AppMetadataEntry> data) {
            this.data = data;
            this.changedFields = changedFields.add("data");
            return this;
        }

        public Builder data(AppMetadataEntry... data) {
            return data(Arrays.asList(data));
        }

        public Builder dataNextLink(String dataNextLink) {
            this.dataNextLink = dataNextLink;
            this.changedFields = changedFields.add("data");
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        public AppMetadata build() {
            AppMetadata _x = new AppMetadata();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.appMetadata";
            _x.data = data;
            _x.dataNextLink = dataNextLink;
            _x.version = version;
            return _x;
        }
    }

    private AppMetadata _copy() {
        AppMetadata _x = new AppMetadata();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.data = data;
        _x.version = version;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AppMetadata[");
        b.append("data=");
        b.append(this.data);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
