package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "keyCredentials", 
    "passwordCredentials"})
@JsonInclude(Include.NON_NULL)
public class AppManagementConfiguration implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("keyCredentials")
    protected List<KeyCredentialConfiguration> keyCredentials;

    @JsonProperty("keyCredentials@nextLink")
    protected String keyCredentialsNextLink;

    @JsonProperty("passwordCredentials")
    protected List<PasswordCredentialConfiguration> passwordCredentials;

    @JsonProperty("passwordCredentials@nextLink")
    protected String passwordCredentialsNextLink;

    protected AppManagementConfiguration() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.appManagementConfiguration";
    }

    @Property(name="keyCredentials")
    @JsonIgnore
    public CollectionPage<KeyCredentialConfiguration> getKeyCredentials() {
        return new CollectionPage<KeyCredentialConfiguration>(contextPath, KeyCredentialConfiguration.class, this.keyCredentials, Optional.ofNullable(keyCredentialsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="keyCredentials")
    @JsonIgnore
    public CollectionPage<KeyCredentialConfiguration> getKeyCredentials(HttpRequestOptions options) {
        return new CollectionPage<KeyCredentialConfiguration>(contextPath, KeyCredentialConfiguration.class, this.keyCredentials, Optional.ofNullable(keyCredentialsNextLink), Collections.emptyList(), options);
    }

    @Property(name="passwordCredentials")
    @JsonIgnore
    public CollectionPage<PasswordCredentialConfiguration> getPasswordCredentials() {
        return new CollectionPage<PasswordCredentialConfiguration>(contextPath, PasswordCredentialConfiguration.class, this.passwordCredentials, Optional.ofNullable(passwordCredentialsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="passwordCredentials")
    @JsonIgnore
    public CollectionPage<PasswordCredentialConfiguration> getPasswordCredentials(HttpRequestOptions options) {
        return new CollectionPage<PasswordCredentialConfiguration>(contextPath, PasswordCredentialConfiguration.class, this.passwordCredentials, Optional.ofNullable(passwordCredentialsNextLink), Collections.emptyList(), options);
    }

    public AppManagementConfiguration withUnmappedField(String name, Object value) {
        AppManagementConfiguration _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<KeyCredentialConfiguration> keyCredentials;
        private String keyCredentialsNextLink;
        private List<PasswordCredentialConfiguration> passwordCredentials;
        private String passwordCredentialsNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder keyCredentials(List<KeyCredentialConfiguration> keyCredentials) {
            this.keyCredentials = keyCredentials;
            this.changedFields = changedFields.add("keyCredentials");
            return this;
        }

        public Builder keyCredentials(KeyCredentialConfiguration... keyCredentials) {
            return keyCredentials(Arrays.asList(keyCredentials));
        }

        public Builder keyCredentialsNextLink(String keyCredentialsNextLink) {
            this.keyCredentialsNextLink = keyCredentialsNextLink;
            this.changedFields = changedFields.add("keyCredentials");
            return this;
        }

        public Builder passwordCredentials(List<PasswordCredentialConfiguration> passwordCredentials) {
            this.passwordCredentials = passwordCredentials;
            this.changedFields = changedFields.add("passwordCredentials");
            return this;
        }

        public Builder passwordCredentials(PasswordCredentialConfiguration... passwordCredentials) {
            return passwordCredentials(Arrays.asList(passwordCredentials));
        }

        public Builder passwordCredentialsNextLink(String passwordCredentialsNextLink) {
            this.passwordCredentialsNextLink = passwordCredentialsNextLink;
            this.changedFields = changedFields.add("passwordCredentials");
            return this;
        }

        public AppManagementConfiguration build() {
            AppManagementConfiguration _x = new AppManagementConfiguration();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.appManagementConfiguration";
            _x.keyCredentials = keyCredentials;
            _x.keyCredentialsNextLink = keyCredentialsNextLink;
            _x.passwordCredentials = passwordCredentials;
            _x.passwordCredentialsNextLink = passwordCredentialsNextLink;
            return _x;
        }
    }

    private AppManagementConfiguration _copy() {
        AppManagementConfiguration _x = new AppManagementConfiguration();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.keyCredentials = keyCredentials;
        _x.passwordCredentials = passwordCredentials;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AppManagementConfiguration[");
        b.append("keyCredentials=");
        b.append(this.keyCredentials);
        b.append(", ");
        b.append("passwordCredentials=");
        b.append(this.passwordCredentials);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
