package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.AppLogDecryptionAlgorithm;

@JsonPropertyOrder({
    "@odata.type", 
    "appLogDecryptionAlgorithm", 
    "decryptionKey", 
    "downloadUrl"})
@JsonInclude(Include.NON_NULL)
public class AppLogCollectionDownloadDetails implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("appLogDecryptionAlgorithm")
    protected AppLogDecryptionAlgorithm appLogDecryptionAlgorithm;

    @JsonProperty("decryptionKey")
    protected String decryptionKey;

    @JsonProperty("downloadUrl")
    protected String downloadUrl;

    protected AppLogCollectionDownloadDetails() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.appLogCollectionDownloadDetails";
    }

    /**
     * <i>“DecryptionAlgorithm for Content”</i>
     * 
     * @return property appLogDecryptionAlgorithm
     */
    @Property(name="appLogDecryptionAlgorithm")
    @JsonIgnore
    public Optional<AppLogDecryptionAlgorithm> getAppLogDecryptionAlgorithm() {
        return Optional.ofNullable(appLogDecryptionAlgorithm);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * appLogDecryptionAlgorithm} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“DecryptionAlgorithm for Content”</i>
     * 
     * @param appLogDecryptionAlgorithm
     *            new value of {@code appLogDecryptionAlgorithm} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appLogDecryptionAlgorithm} field changed
     */
    public AppLogCollectionDownloadDetails withAppLogDecryptionAlgorithm(AppLogDecryptionAlgorithm appLogDecryptionAlgorithm) {
        AppLogCollectionDownloadDetails _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appLogCollectionDownloadDetails");
        _x.appLogDecryptionAlgorithm = appLogDecryptionAlgorithm;
        return _x;
    }

    /**
     * <i>“DecryptionKey as string”</i>
     * 
     * @return property decryptionKey
     */
    @Property(name="decryptionKey")
    @JsonIgnore
    public Optional<String> getDecryptionKey() {
        return Optional.ofNullable(decryptionKey);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code decryptionKey}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“DecryptionKey as string”</i>
     * 
     * @param decryptionKey
     *            new value of {@code decryptionKey} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code decryptionKey} field changed
     */
    public AppLogCollectionDownloadDetails withDecryptionKey(String decryptionKey) {
        AppLogCollectionDownloadDetails _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appLogCollectionDownloadDetails");
        _x.decryptionKey = decryptionKey;
        return _x;
    }

    /**
     * <i>“Download SAS Url for completed AppLogUploadRequest”</i>
     * 
     * @return property downloadUrl
     */
    @Property(name="downloadUrl")
    @JsonIgnore
    public Optional<String> getDownloadUrl() {
        return Optional.ofNullable(downloadUrl);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code downloadUrl}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Download SAS Url for completed AppLogUploadRequest”</i>
     * 
     * @param downloadUrl
     *            new value of {@code downloadUrl} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code downloadUrl} field changed
     */
    public AppLogCollectionDownloadDetails withDownloadUrl(String downloadUrl) {
        AppLogCollectionDownloadDetails _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appLogCollectionDownloadDetails");
        _x.downloadUrl = downloadUrl;
        return _x;
    }

    public AppLogCollectionDownloadDetails withUnmappedField(String name, Object value) {
        AppLogCollectionDownloadDetails _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private AppLogDecryptionAlgorithm appLogDecryptionAlgorithm;
        private String decryptionKey;
        private String downloadUrl;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“DecryptionAlgorithm for Content”</i>
         * 
         * @param appLogDecryptionAlgorithm
         *            value of {@code appLogDecryptionAlgorithm} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appLogDecryptionAlgorithm(AppLogDecryptionAlgorithm appLogDecryptionAlgorithm) {
            this.appLogDecryptionAlgorithm = appLogDecryptionAlgorithm;
            this.changedFields = changedFields.add("appLogDecryptionAlgorithm");
            return this;
        }

        /**
         * <i>“DecryptionKey as string”</i>
         * 
         * @param decryptionKey
         *            value of {@code decryptionKey} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder decryptionKey(String decryptionKey) {
            this.decryptionKey = decryptionKey;
            this.changedFields = changedFields.add("decryptionKey");
            return this;
        }

        /**
         * <i>“Download SAS Url for completed AppLogUploadRequest”</i>
         * 
         * @param downloadUrl
         *            value of {@code downloadUrl} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder downloadUrl(String downloadUrl) {
            this.downloadUrl = downloadUrl;
            this.changedFields = changedFields.add("downloadUrl");
            return this;
        }

        public AppLogCollectionDownloadDetails build() {
            AppLogCollectionDownloadDetails _x = new AppLogCollectionDownloadDetails();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.appLogCollectionDownloadDetails";
            _x.appLogDecryptionAlgorithm = appLogDecryptionAlgorithm;
            _x.decryptionKey = decryptionKey;
            _x.downloadUrl = downloadUrl;
            return _x;
        }
    }

    private AppLogCollectionDownloadDetails _copy() {
        AppLogCollectionDownloadDetails _x = new AppLogCollectionDownloadDetails();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.appLogDecryptionAlgorithm = appLogDecryptionAlgorithm;
        _x.decryptionKey = decryptionKey;
        _x.downloadUrl = downloadUrl;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AppLogCollectionDownloadDetails[");
        b.append("appLogDecryptionAlgorithm=");
        b.append(this.appLogDecryptionAlgorithm);
        b.append(", ");
        b.append("decryptionKey=");
        b.append(this.decryptionKey);
        b.append(", ");
        b.append("downloadUrl=");
        b.append(this.downloadUrl);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
