package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "blob"})
@JsonInclude(Include.NON_NULL)
public class AppHostedMediaConfig extends MediaConfig implements ODataType {

    @JsonProperty("blob")
    protected String blob;

    protected AppHostedMediaConfig() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.appHostedMediaConfig";
    }

    @Property(name="blob")
    @JsonIgnore
    public Optional<String> getBlob() {
        return Optional.ofNullable(blob);
    }

    public AppHostedMediaConfig withBlob(String blob) {
        AppHostedMediaConfig _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appHostedMediaConfig");
        _x.blob = blob;
        return _x;
    }

    public AppHostedMediaConfig withUnmappedField(String name, Object value) {
        AppHostedMediaConfig _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAppHostedMediaConfig() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean removeFromDefaultAudioGroup;
        private String blob;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder removeFromDefaultAudioGroup(Boolean removeFromDefaultAudioGroup) {
            this.removeFromDefaultAudioGroup = removeFromDefaultAudioGroup;
            this.changedFields = changedFields.add("removeFromDefaultAudioGroup");
            return this;
        }

        public Builder blob(String blob) {
            this.blob = blob;
            this.changedFields = changedFields.add("blob");
            return this;
        }

        public AppHostedMediaConfig build() {
            AppHostedMediaConfig _x = new AppHostedMediaConfig();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.appHostedMediaConfig";
            _x.removeFromDefaultAudioGroup = removeFromDefaultAudioGroup;
            _x.blob = blob;
            return _x;
        }
    }

    private AppHostedMediaConfig _copy() {
        AppHostedMediaConfig _x = new AppHostedMediaConfig();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.removeFromDefaultAudioGroup = removeFromDefaultAudioGroup;
        _x.blob = blob;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AppHostedMediaConfig[");
        b.append("removeFromDefaultAudioGroup=");
        b.append(this.removeFromDefaultAudioGroup);
        b.append(", ");
        b.append("blob=");
        b.append(this.blob);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
