package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.AndroidManagedStoreAutoUpdateMode;


/**
 * <i>“Contains properties used to assign an Android Managed Store mobile app to a
 * group.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "androidManagedStoreAppTrackIds", 
    "autoUpdateMode"})
@JsonInclude(Include.NON_NULL)
public class AndroidManagedStoreAppAssignmentSettings extends MobileAppAssignmentSettings implements ODataType {

    @JsonProperty("androidManagedStoreAppTrackIds")
    protected List<String> androidManagedStoreAppTrackIds;

    @JsonProperty("androidManagedStoreAppTrackIds@nextLink")
    protected String androidManagedStoreAppTrackIdsNextLink;

    @JsonProperty("autoUpdateMode")
    protected AndroidManagedStoreAutoUpdateMode autoUpdateMode;

    protected AndroidManagedStoreAppAssignmentSettings() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.androidManagedStoreAppAssignmentSettings";
    }

    /**
     * <i>“The track IDs to enable for this app assignment.”</i>
     * 
     * @return property androidManagedStoreAppTrackIds
     */
    @Property(name="androidManagedStoreAppTrackIds")
    @JsonIgnore
    public CollectionPage<String> getAndroidManagedStoreAppTrackIds() {
        return new CollectionPage<String>(contextPath, String.class, this.androidManagedStoreAppTrackIds, Optional.ofNullable(androidManagedStoreAppTrackIdsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“The track IDs to enable for this app assignment.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property androidManagedStoreAppTrackIds
     */
    @Property(name="androidManagedStoreAppTrackIds")
    @JsonIgnore
    public CollectionPage<String> getAndroidManagedStoreAppTrackIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.androidManagedStoreAppTrackIds, Optional.ofNullable(androidManagedStoreAppTrackIdsNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“The prioritization of automatic updates for this app assignment.”</i>
     * 
     * @return property autoUpdateMode
     */
    @Property(name="autoUpdateMode")
    @JsonIgnore
    public Optional<AndroidManagedStoreAutoUpdateMode> getAutoUpdateMode() {
        return Optional.ofNullable(autoUpdateMode);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code autoUpdateMode}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The prioritization of automatic updates for this app assignment.”</i>
     * 
     * @param autoUpdateMode
     *            new value of {@code autoUpdateMode} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code autoUpdateMode} field changed
     */
    public AndroidManagedStoreAppAssignmentSettings withAutoUpdateMode(AndroidManagedStoreAutoUpdateMode autoUpdateMode) {
        AndroidManagedStoreAppAssignmentSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidManagedStoreAppAssignmentSettings");
        _x.autoUpdateMode = autoUpdateMode;
        return _x;
    }

    public AndroidManagedStoreAppAssignmentSettings withUnmappedField(String name, Object value) {
        AndroidManagedStoreAppAssignmentSettings _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAndroidManagedStoreAppAssignmentSettings() {
        return new Builder();
    }

    public static final class Builder {
        private List<String> androidManagedStoreAppTrackIds;
        private String androidManagedStoreAppTrackIdsNextLink;
        private AndroidManagedStoreAutoUpdateMode autoUpdateMode;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“The track IDs to enable for this app assignment.”</i>
         * 
         * @param androidManagedStoreAppTrackIds
         *            value of {@code androidManagedStoreAppTrackIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder androidManagedStoreAppTrackIds(List<String> androidManagedStoreAppTrackIds) {
            this.androidManagedStoreAppTrackIds = androidManagedStoreAppTrackIds;
            this.changedFields = changedFields.add("androidManagedStoreAppTrackIds");
            return this;
        }

        /**
         * <i>“The track IDs to enable for this app assignment.”</i>
         * 
         * @param androidManagedStoreAppTrackIds
         *            value of {@code androidManagedStoreAppTrackIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder androidManagedStoreAppTrackIds(String... androidManagedStoreAppTrackIds) {
            return androidManagedStoreAppTrackIds(Arrays.asList(androidManagedStoreAppTrackIds));
        }

        /**
         * <i>“The track IDs to enable for this app assignment.”</i>
         * 
         * @param androidManagedStoreAppTrackIdsNextLink
         *            value of {@code androidManagedStoreAppTrackIds@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder androidManagedStoreAppTrackIdsNextLink(String androidManagedStoreAppTrackIdsNextLink) {
            this.androidManagedStoreAppTrackIdsNextLink = androidManagedStoreAppTrackIdsNextLink;
            this.changedFields = changedFields.add("androidManagedStoreAppTrackIds");
            return this;
        }

        /**
         * <i>“The prioritization of automatic updates for this app assignment.”</i>
         * 
         * @param autoUpdateMode
         *            value of {@code autoUpdateMode} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder autoUpdateMode(AndroidManagedStoreAutoUpdateMode autoUpdateMode) {
            this.autoUpdateMode = autoUpdateMode;
            this.changedFields = changedFields.add("autoUpdateMode");
            return this;
        }

        public AndroidManagedStoreAppAssignmentSettings build() {
            AndroidManagedStoreAppAssignmentSettings _x = new AndroidManagedStoreAppAssignmentSettings();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.androidManagedStoreAppAssignmentSettings";
            _x.androidManagedStoreAppTrackIds = androidManagedStoreAppTrackIds;
            _x.androidManagedStoreAppTrackIdsNextLink = androidManagedStoreAppTrackIdsNextLink;
            _x.autoUpdateMode = autoUpdateMode;
            return _x;
        }
    }

    private AndroidManagedStoreAppAssignmentSettings _copy() {
        AndroidManagedStoreAppAssignmentSettings _x = new AndroidManagedStoreAppAssignmentSettings();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.androidManagedStoreAppTrackIds = androidManagedStoreAppTrackIds;
        _x.autoUpdateMode = autoUpdateMode;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AndroidManagedStoreAppAssignmentSettings[");
        b.append("androidManagedStoreAppTrackIds=");
        b.append(this.androidManagedStoreAppTrackIds);
        b.append(", ");
        b.append("autoUpdateMode=");
        b.append(this.autoUpdateMode);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
