package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.AndroidForWorkAppConfigurationSchemaItemDataType;


/**
 * <i>“Single configuration item inside an Android for Work application's custom
 * configuration schema.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "dataType", 
    "defaultBoolValue", 
    "defaultIntValue", 
    "defaultStringArrayValue", 
    "defaultStringValue", 
    "description", 
    "displayName", 
    "schemaItemKey", 
    "selections"})
@JsonInclude(Include.NON_NULL)
public class AndroidForWorkAppConfigurationSchemaItem implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("dataType")
    protected AndroidForWorkAppConfigurationSchemaItemDataType dataType;

    @JsonProperty("defaultBoolValue")
    protected Boolean defaultBoolValue;

    @JsonProperty("defaultIntValue")
    protected Integer defaultIntValue;

    @JsonProperty("defaultStringArrayValue")
    protected List<String> defaultStringArrayValue;

    @JsonProperty("defaultStringArrayValue@nextLink")
    protected String defaultStringArrayValueNextLink;

    @JsonProperty("defaultStringValue")
    protected String defaultStringValue;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("schemaItemKey")
    protected String schemaItemKey;

    @JsonProperty("selections")
    protected List<KeyValuePair> selections;

    @JsonProperty("selections@nextLink")
    protected String selectionsNextLink;

    protected AndroidForWorkAppConfigurationSchemaItem() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.androidForWorkAppConfigurationSchemaItem";
    }

    /**
     * <i>“The type of value this item describes”</i>
     * 
     * @return property dataType
     */
    @Property(name="dataType")
    @JsonIgnore
    public Optional<AndroidForWorkAppConfigurationSchemaItemDataType> getDataType() {
        return Optional.ofNullable(dataType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code dataType} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The type of value this item describes”</i>
     * 
     * @param dataType
     *            new value of {@code dataType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code dataType} field changed
     */
    public AndroidForWorkAppConfigurationSchemaItem withDataType(AndroidForWorkAppConfigurationSchemaItemDataType dataType) {
        AndroidForWorkAppConfigurationSchemaItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidForWorkAppConfigurationSchemaItem");
        _x.dataType = dataType;
        return _x;
    }

    /**
     * <i>“Default value for boolean type items, if specified by the app developer”</i>
     * 
     * @return property defaultBoolValue
     */
    @Property(name="defaultBoolValue")
    @JsonIgnore
    public Optional<Boolean> getDefaultBoolValue() {
        return Optional.ofNullable(defaultBoolValue);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code defaultBoolValue}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Default value for boolean type items, if specified by the app developer”</i>
     * 
     * @param defaultBoolValue
     *            new value of {@code defaultBoolValue} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defaultBoolValue} field changed
     */
    public AndroidForWorkAppConfigurationSchemaItem withDefaultBoolValue(Boolean defaultBoolValue) {
        AndroidForWorkAppConfigurationSchemaItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidForWorkAppConfigurationSchemaItem");
        _x.defaultBoolValue = defaultBoolValue;
        return _x;
    }

    /**
     * <i>“Default value for integer type items, if specified by the app developer”</i>
     * 
     * @return property defaultIntValue
     */
    @Property(name="defaultIntValue")
    @JsonIgnore
    public Optional<Integer> getDefaultIntValue() {
        return Optional.ofNullable(defaultIntValue);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code defaultIntValue}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Default value for integer type items, if specified by the app developer”</i>
     * 
     * @param defaultIntValue
     *            new value of {@code defaultIntValue} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defaultIntValue} field changed
     */
    public AndroidForWorkAppConfigurationSchemaItem withDefaultIntValue(Integer defaultIntValue) {
        AndroidForWorkAppConfigurationSchemaItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidForWorkAppConfigurationSchemaItem");
        _x.defaultIntValue = defaultIntValue;
        return _x;
    }

    /**
     * <i>“Default value for string array type items, if specified by the app developer”</i>
     * 
     * @return property defaultStringArrayValue
     */
    @Property(name="defaultStringArrayValue")
    @JsonIgnore
    public CollectionPage<String> getDefaultStringArrayValue() {
        return new CollectionPage<String>(contextPath, String.class, this.defaultStringArrayValue, Optional.ofNullable(defaultStringArrayValueNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Default value for string array type items, if specified by the app developer”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property defaultStringArrayValue
     */
    @Property(name="defaultStringArrayValue")
    @JsonIgnore
    public CollectionPage<String> getDefaultStringArrayValue(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.defaultStringArrayValue, Optional.ofNullable(defaultStringArrayValueNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Default value for string type items, if specified by the app developer”</i>
     * 
     * @return property defaultStringValue
     */
    @Property(name="defaultStringValue")
    @JsonIgnore
    public Optional<String> getDefaultStringValue() {
        return Optional.ofNullable(defaultStringValue);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defaultStringValue} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Default value for string type items, if specified by the app developer”</i>
     * 
     * @param defaultStringValue
     *            new value of {@code defaultStringValue} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defaultStringValue} field changed
     */
    public AndroidForWorkAppConfigurationSchemaItem withDefaultStringValue(String defaultStringValue) {
        AndroidForWorkAppConfigurationSchemaItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidForWorkAppConfigurationSchemaItem");
        _x.defaultStringValue = defaultStringValue;
        return _x;
    }

    /**
     * <i>“Description of what the item controls within the application”</i>
     * 
     * @return property description
     */
    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code description}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Description of what the item controls within the application”</i>
     * 
     * @param description
     *            new value of {@code description} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code description} field changed
     */
    public AndroidForWorkAppConfigurationSchemaItem withDescription(String description) {
        AndroidForWorkAppConfigurationSchemaItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidForWorkAppConfigurationSchemaItem");
        _x.description = description;
        return _x;
    }

    /**
     * <i>“Human readable name”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Human readable name”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public AndroidForWorkAppConfigurationSchemaItem withDisplayName(String displayName) {
        AndroidForWorkAppConfigurationSchemaItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidForWorkAppConfigurationSchemaItem");
        _x.displayName = displayName;
        return _x;
    }

    /**
     * <i>“Unique key the application uses to identify the item”</i>
     * 
     * @return property schemaItemKey
     */
    @Property(name="schemaItemKey")
    @JsonIgnore
    public Optional<String> getSchemaItemKey() {
        return Optional.ofNullable(schemaItemKey);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code schemaItemKey}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Unique key the application uses to identify the item”</i>
     * 
     * @param schemaItemKey
     *            new value of {@code schemaItemKey} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code schemaItemKey} field changed
     */
    public AndroidForWorkAppConfigurationSchemaItem withSchemaItemKey(String schemaItemKey) {
        AndroidForWorkAppConfigurationSchemaItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidForWorkAppConfigurationSchemaItem");
        _x.schemaItemKey = schemaItemKey;
        return _x;
    }

    /**
     * <i>“List of human readable name/value pairs for the valid values that can be set for
     * this item (Choice and Multiselect items only)”</i>
     * 
     * @return property selections
     */
    @Property(name="selections")
    @JsonIgnore
    public CollectionPage<KeyValuePair> getSelections() {
        return new CollectionPage<KeyValuePair>(contextPath, KeyValuePair.class, this.selections, Optional.ofNullable(selectionsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“List of human readable name/value pairs for the valid values that can be set for
     * this item (Choice and Multiselect items only)”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property selections
     */
    @Property(name="selections")
    @JsonIgnore
    public CollectionPage<KeyValuePair> getSelections(HttpRequestOptions options) {
        return new CollectionPage<KeyValuePair>(contextPath, KeyValuePair.class, this.selections, Optional.ofNullable(selectionsNextLink), Collections.emptyList(), options);
    }

    public AndroidForWorkAppConfigurationSchemaItem withUnmappedField(String name, Object value) {
        AndroidForWorkAppConfigurationSchemaItem _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private AndroidForWorkAppConfigurationSchemaItemDataType dataType;
        private Boolean defaultBoolValue;
        private Integer defaultIntValue;
        private List<String> defaultStringArrayValue;
        private String defaultStringArrayValueNextLink;
        private String defaultStringValue;
        private String description;
        private String displayName;
        private String schemaItemKey;
        private List<KeyValuePair> selections;
        private String selectionsNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“The type of value this item describes”</i>
         * 
         * @param dataType
         *            value of {@code dataType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder dataType(AndroidForWorkAppConfigurationSchemaItemDataType dataType) {
            this.dataType = dataType;
            this.changedFields = changedFields.add("dataType");
            return this;
        }

        /**
         * <i>“Default value for boolean type items, if specified by the app developer”</i>
         * 
         * @param defaultBoolValue
         *            value of {@code defaultBoolValue} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defaultBoolValue(Boolean defaultBoolValue) {
            this.defaultBoolValue = defaultBoolValue;
            this.changedFields = changedFields.add("defaultBoolValue");
            return this;
        }

        /**
         * <i>“Default value for integer type items, if specified by the app developer”</i>
         * 
         * @param defaultIntValue
         *            value of {@code defaultIntValue} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defaultIntValue(Integer defaultIntValue) {
            this.defaultIntValue = defaultIntValue;
            this.changedFields = changedFields.add("defaultIntValue");
            return this;
        }

        /**
         * <i>“Default value for string array type items, if specified by the app developer”</i>
         * 
         * @param defaultStringArrayValue
         *            value of {@code defaultStringArrayValue} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defaultStringArrayValue(List<String> defaultStringArrayValue) {
            this.defaultStringArrayValue = defaultStringArrayValue;
            this.changedFields = changedFields.add("defaultStringArrayValue");
            return this;
        }

        /**
         * <i>“Default value for string array type items, if specified by the app developer”</i>
         * 
         * @param defaultStringArrayValue
         *            value of {@code defaultStringArrayValue} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defaultStringArrayValue(String... defaultStringArrayValue) {
            return defaultStringArrayValue(Arrays.asList(defaultStringArrayValue));
        }

        /**
         * <i>“Default value for string array type items, if specified by the app developer”</i>
         * 
         * @param defaultStringArrayValueNextLink
         *            value of {@code defaultStringArrayValue@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defaultStringArrayValueNextLink(String defaultStringArrayValueNextLink) {
            this.defaultStringArrayValueNextLink = defaultStringArrayValueNextLink;
            this.changedFields = changedFields.add("defaultStringArrayValue");
            return this;
        }

        /**
         * <i>“Default value for string type items, if specified by the app developer”</i>
         * 
         * @param defaultStringValue
         *            value of {@code defaultStringValue} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defaultStringValue(String defaultStringValue) {
            this.defaultStringValue = defaultStringValue;
            this.changedFields = changedFields.add("defaultStringValue");
            return this;
        }

        /**
         * <i>“Description of what the item controls within the application”</i>
         * 
         * @param description
         *            value of {@code description} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        /**
         * <i>“Human readable name”</i>
         * 
         * @param displayName
         *            value of {@code displayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        /**
         * <i>“Unique key the application uses to identify the item”</i>
         * 
         * @param schemaItemKey
         *            value of {@code schemaItemKey} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder schemaItemKey(String schemaItemKey) {
            this.schemaItemKey = schemaItemKey;
            this.changedFields = changedFields.add("schemaItemKey");
            return this;
        }

        /**
         * <i>“List of human readable name/value pairs for the valid values that can be set for
         * this item (Choice and Multiselect items only)”</i>
         * 
         * @param selections
         *            value of {@code selections} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder selections(List<KeyValuePair> selections) {
            this.selections = selections;
            this.changedFields = changedFields.add("selections");
            return this;
        }

        /**
         * <i>“List of human readable name/value pairs for the valid values that can be set for
         * this item (Choice and Multiselect items only)”</i>
         * 
         * @param selections
         *            value of {@code selections} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder selections(KeyValuePair... selections) {
            return selections(Arrays.asList(selections));
        }

        /**
         * <i>“List of human readable name/value pairs for the valid values that can be set for
         * this item (Choice and Multiselect items only)”</i>
         * 
         * @param selectionsNextLink
         *            value of {@code selections@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder selectionsNextLink(String selectionsNextLink) {
            this.selectionsNextLink = selectionsNextLink;
            this.changedFields = changedFields.add("selections");
            return this;
        }

        public AndroidForWorkAppConfigurationSchemaItem build() {
            AndroidForWorkAppConfigurationSchemaItem _x = new AndroidForWorkAppConfigurationSchemaItem();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.androidForWorkAppConfigurationSchemaItem";
            _x.dataType = dataType;
            _x.defaultBoolValue = defaultBoolValue;
            _x.defaultIntValue = defaultIntValue;
            _x.defaultStringArrayValue = defaultStringArrayValue;
            _x.defaultStringArrayValueNextLink = defaultStringArrayValueNextLink;
            _x.defaultStringValue = defaultStringValue;
            _x.description = description;
            _x.displayName = displayName;
            _x.schemaItemKey = schemaItemKey;
            _x.selections = selections;
            _x.selectionsNextLink = selectionsNextLink;
            return _x;
        }
    }

    private AndroidForWorkAppConfigurationSchemaItem _copy() {
        AndroidForWorkAppConfigurationSchemaItem _x = new AndroidForWorkAppConfigurationSchemaItem();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.dataType = dataType;
        _x.defaultBoolValue = defaultBoolValue;
        _x.defaultIntValue = defaultIntValue;
        _x.defaultStringArrayValue = defaultStringArrayValue;
        _x.defaultStringValue = defaultStringValue;
        _x.description = description;
        _x.displayName = displayName;
        _x.schemaItemKey = schemaItemKey;
        _x.selections = selections;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AndroidForWorkAppConfigurationSchemaItem[");
        b.append("dataType=");
        b.append(this.dataType);
        b.append(", ");
        b.append("defaultBoolValue=");
        b.append(this.defaultBoolValue);
        b.append(", ");
        b.append("defaultIntValue=");
        b.append(this.defaultIntValue);
        b.append(", ");
        b.append("defaultStringArrayValue=");
        b.append(this.defaultStringArrayValue);
        b.append(", ");
        b.append("defaultStringValue=");
        b.append(this.defaultStringValue);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("schemaItemKey=");
        b.append(this.schemaItemKey);
        b.append(", ");
        b.append("selections=");
        b.append(this.selections);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
