package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“A class to hold specialty enrollment data used for enrolling via Google's
 * Android Management API, such as Token, Url, and QR code content”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "enrollmentToken", 
    "qrCodeContent", 
    "qrCodeImage"})
@JsonInclude(Include.NON_NULL)
public class AndroidEnrollmentCompanyCode implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("enrollmentToken")
    protected String enrollmentToken;

    @JsonProperty("qrCodeContent")
    protected String qrCodeContent;

    @JsonProperty("qrCodeImage")
    protected MimeContent qrCodeImage;

    protected AndroidEnrollmentCompanyCode() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.androidEnrollmentCompanyCode";
    }

    /**
     * <i>“Enrollment Token used by the User to enroll their device.”</i>
     * 
     * @return property enrollmentToken
     */
    @Property(name="enrollmentToken")
    @JsonIgnore
    public Optional<String> getEnrollmentToken() {
        return Optional.ofNullable(enrollmentToken);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code enrollmentToken}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Enrollment Token used by the User to enroll their device.”</i>
     * 
     * @param enrollmentToken
     *            new value of {@code enrollmentToken} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code enrollmentToken} field changed
     */
    public AndroidEnrollmentCompanyCode withEnrollmentToken(String enrollmentToken) {
        AndroidEnrollmentCompanyCode _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidEnrollmentCompanyCode");
        _x.enrollmentToken = enrollmentToken;
        return _x;
    }

    /**
     * <i>“String used to generate a QR code for the token.”</i>
     * 
     * @return property qrCodeContent
     */
    @Property(name="qrCodeContent")
    @JsonIgnore
    public Optional<String> getQrCodeContent() {
        return Optional.ofNullable(qrCodeContent);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code qrCodeContent}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“String used to generate a QR code for the token.”</i>
     * 
     * @param qrCodeContent
     *            new value of {@code qrCodeContent} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code qrCodeContent} field changed
     */
    public AndroidEnrollmentCompanyCode withQrCodeContent(String qrCodeContent) {
        AndroidEnrollmentCompanyCode _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidEnrollmentCompanyCode");
        _x.qrCodeContent = qrCodeContent;
        return _x;
    }

    /**
     * <i>“Generated QR code for the token.”</i>
     * 
     * @return property qrCodeImage
     */
    @Property(name="qrCodeImage")
    @JsonIgnore
    public Optional<MimeContent> getQrCodeImage() {
        return Optional.ofNullable(qrCodeImage);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code qrCodeImage}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Generated QR code for the token.”</i>
     * 
     * @param qrCodeImage
     *            new value of {@code qrCodeImage} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code qrCodeImage} field changed
     */
    public AndroidEnrollmentCompanyCode withQrCodeImage(MimeContent qrCodeImage) {
        AndroidEnrollmentCompanyCode _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidEnrollmentCompanyCode");
        _x.qrCodeImage = qrCodeImage;
        return _x;
    }

    public AndroidEnrollmentCompanyCode withUnmappedField(String name, Object value) {
        AndroidEnrollmentCompanyCode _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String enrollmentToken;
        private String qrCodeContent;
        private MimeContent qrCodeImage;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Enrollment Token used by the User to enroll their device.”</i>
         * 
         * @param enrollmentToken
         *            value of {@code enrollmentToken} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder enrollmentToken(String enrollmentToken) {
            this.enrollmentToken = enrollmentToken;
            this.changedFields = changedFields.add("enrollmentToken");
            return this;
        }

        /**
         * <i>“String used to generate a QR code for the token.”</i>
         * 
         * @param qrCodeContent
         *            value of {@code qrCodeContent} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder qrCodeContent(String qrCodeContent) {
            this.qrCodeContent = qrCodeContent;
            this.changedFields = changedFields.add("qrCodeContent");
            return this;
        }

        /**
         * <i>“Generated QR code for the token.”</i>
         * 
         * @param qrCodeImage
         *            value of {@code qrCodeImage} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder qrCodeImage(MimeContent qrCodeImage) {
            this.qrCodeImage = qrCodeImage;
            this.changedFields = changedFields.add("qrCodeImage");
            return this;
        }

        public AndroidEnrollmentCompanyCode build() {
            AndroidEnrollmentCompanyCode _x = new AndroidEnrollmentCompanyCode();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.androidEnrollmentCompanyCode";
            _x.enrollmentToken = enrollmentToken;
            _x.qrCodeContent = qrCodeContent;
            _x.qrCodeImage = qrCodeImage;
            return _x;
        }
    }

    private AndroidEnrollmentCompanyCode _copy() {
        AndroidEnrollmentCompanyCode _x = new AndroidEnrollmentCompanyCode();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.enrollmentToken = enrollmentToken;
        _x.qrCodeContent = qrCodeContent;
        _x.qrCodeImage = qrCodeImage;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AndroidEnrollmentCompanyCode[");
        b.append("enrollmentToken=");
        b.append(this.enrollmentToken);
        b.append(", ");
        b.append("qrCodeContent=");
        b.append(this.qrCodeContent);
        b.append(", ");
        b.append("qrCodeImage=");
        b.append(this.qrCodeImage);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
