package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“Represents one item in the list of freeze periods for Android Device Owner
 * system updates”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "endDay", 
    "endMonth", 
    "startDay", 
    "startMonth"})
@JsonInclude(Include.NON_NULL)
public class AndroidDeviceOwnerSystemUpdateFreezePeriod implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("endDay")
    protected Integer endDay;

    @JsonProperty("endMonth")
    protected Integer endMonth;

    @JsonProperty("startDay")
    protected Integer startDay;

    @JsonProperty("startMonth")
    protected Integer startMonth;

    protected AndroidDeviceOwnerSystemUpdateFreezePeriod() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.androidDeviceOwnerSystemUpdateFreezePeriod";
    }

    /**
     * <i>“The day of the end date of the freeze period. Valid values 1 to 31”</i>
     * 
     * @return property endDay
     */
    @Property(name="endDay")
    @JsonIgnore
    public Optional<Integer> getEndDay() {
        return Optional.ofNullable(endDay);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code endDay} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The day of the end date of the freeze period. Valid values 1 to 31”</i>
     * 
     * @param endDay
     *            new value of {@code endDay} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code endDay} field changed
     */
    public AndroidDeviceOwnerSystemUpdateFreezePeriod withEndDay(Integer endDay) {
        AndroidDeviceOwnerSystemUpdateFreezePeriod _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerSystemUpdateFreezePeriod");
        _x.endDay = endDay;
        return _x;
    }

    /**
     * <i>“The month of the end date of the freeze period. Valid values 1 to 12”</i>
     * 
     * @return property endMonth
     */
    @Property(name="endMonth")
    @JsonIgnore
    public Optional<Integer> getEndMonth() {
        return Optional.ofNullable(endMonth);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code endMonth} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The month of the end date of the freeze period. Valid values 1 to 12”</i>
     * 
     * @param endMonth
     *            new value of {@code endMonth} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code endMonth} field changed
     */
    public AndroidDeviceOwnerSystemUpdateFreezePeriod withEndMonth(Integer endMonth) {
        AndroidDeviceOwnerSystemUpdateFreezePeriod _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerSystemUpdateFreezePeriod");
        _x.endMonth = endMonth;
        return _x;
    }

    /**
     * <i>“The day of the start date of the freeze period. Valid values 1 to 31”</i>
     * 
     * @return property startDay
     */
    @Property(name="startDay")
    @JsonIgnore
    public Optional<Integer> getStartDay() {
        return Optional.ofNullable(startDay);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code startDay} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The day of the start date of the freeze period. Valid values 1 to 31”</i>
     * 
     * @param startDay
     *            new value of {@code startDay} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code startDay} field changed
     */
    public AndroidDeviceOwnerSystemUpdateFreezePeriod withStartDay(Integer startDay) {
        AndroidDeviceOwnerSystemUpdateFreezePeriod _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerSystemUpdateFreezePeriod");
        _x.startDay = startDay;
        return _x;
    }

    /**
     * <i>“The month of the start date of the freeze period. Valid values 1 to 12”</i>
     * 
     * @return property startMonth
     */
    @Property(name="startMonth")
    @JsonIgnore
    public Optional<Integer> getStartMonth() {
        return Optional.ofNullable(startMonth);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code startMonth} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The month of the start date of the freeze period. Valid values 1 to 12”</i>
     * 
     * @param startMonth
     *            new value of {@code startMonth} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code startMonth} field changed
     */
    public AndroidDeviceOwnerSystemUpdateFreezePeriod withStartMonth(Integer startMonth) {
        AndroidDeviceOwnerSystemUpdateFreezePeriod _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerSystemUpdateFreezePeriod");
        _x.startMonth = startMonth;
        return _x;
    }

    public AndroidDeviceOwnerSystemUpdateFreezePeriod withUnmappedField(String name, Object value) {
        AndroidDeviceOwnerSystemUpdateFreezePeriod _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer endDay;
        private Integer endMonth;
        private Integer startDay;
        private Integer startMonth;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“The day of the end date of the freeze period. Valid values 1 to 31”</i>
         * 
         * @param endDay
         *            value of {@code endDay} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder endDay(Integer endDay) {
            this.endDay = endDay;
            this.changedFields = changedFields.add("endDay");
            return this;
        }

        /**
         * <i>“The month of the end date of the freeze period. Valid values 1 to 12”</i>
         * 
         * @param endMonth
         *            value of {@code endMonth} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder endMonth(Integer endMonth) {
            this.endMonth = endMonth;
            this.changedFields = changedFields.add("endMonth");
            return this;
        }

        /**
         * <i>“The day of the start date of the freeze period. Valid values 1 to 31”</i>
         * 
         * @param startDay
         *            value of {@code startDay} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder startDay(Integer startDay) {
            this.startDay = startDay;
            this.changedFields = changedFields.add("startDay");
            return this;
        }

        /**
         * <i>“The month of the start date of the freeze period. Valid values 1 to 12”</i>
         * 
         * @param startMonth
         *            value of {@code startMonth} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder startMonth(Integer startMonth) {
            this.startMonth = startMonth;
            this.changedFields = changedFields.add("startMonth");
            return this;
        }

        public AndroidDeviceOwnerSystemUpdateFreezePeriod build() {
            AndroidDeviceOwnerSystemUpdateFreezePeriod _x = new AndroidDeviceOwnerSystemUpdateFreezePeriod();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.androidDeviceOwnerSystemUpdateFreezePeriod";
            _x.endDay = endDay;
            _x.endMonth = endMonth;
            _x.startDay = startDay;
            _x.startMonth = startMonth;
            return _x;
        }
    }

    private AndroidDeviceOwnerSystemUpdateFreezePeriod _copy() {
        AndroidDeviceOwnerSystemUpdateFreezePeriod _x = new AndroidDeviceOwnerSystemUpdateFreezePeriod();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.endDay = endDay;
        _x.endMonth = endMonth;
        _x.startDay = startDay;
        _x.startMonth = startMonth;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AndroidDeviceOwnerSystemUpdateFreezePeriod[");
        b.append("endDay=");
        b.append(this.endDay);
        b.append(", ");
        b.append("endMonth=");
        b.append(this.endMonth);
        b.append(", ");
        b.append("startDay=");
        b.append(this.startDay);
        b.append(", ");
        b.append("startMonth=");
        b.append(this.startMonth);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
