package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“A weblink on the Android Device Owner Managed Home Screen”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "label", 
    "link"})
@JsonInclude(Include.NON_NULL)
public class AndroidDeviceOwnerKioskModeWeblink extends AndroidDeviceOwnerKioskModeFolderItem implements ODataType {

    @JsonProperty("label")
    protected String label;

    @JsonProperty("link")
    protected String link;

    protected AndroidDeviceOwnerKioskModeWeblink() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.androidDeviceOwnerKioskModeWeblink";
    }

    /**
     * <i>“Display name for weblink”</i>
     * 
     * @return property label
     */
    @Property(name="label")
    @JsonIgnore
    public Optional<String> getLabel() {
        return Optional.ofNullable(label);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code label} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Display name for weblink”</i>
     * 
     * @param label
     *            new value of {@code label} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code label} field changed
     */
    public AndroidDeviceOwnerKioskModeWeblink withLabel(String label) {
        AndroidDeviceOwnerKioskModeWeblink _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerKioskModeWeblink");
        _x.label = label;
        return _x;
    }

    /**
     * <i>“Link for weblink”</i>
     * 
     * @return property link
     */
    @Property(name="link")
    @JsonIgnore
    public Optional<String> getLink() {
        return Optional.ofNullable(link);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code link} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Link for weblink”</i>
     * 
     * @param link
     *            new value of {@code link} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code link} field changed
     */
    public AndroidDeviceOwnerKioskModeWeblink withLink(String link) {
        AndroidDeviceOwnerKioskModeWeblink _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerKioskModeWeblink");
        _x.link = link;
        return _x;
    }

    public AndroidDeviceOwnerKioskModeWeblink withUnmappedField(String name, Object value) {
        AndroidDeviceOwnerKioskModeWeblink _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAndroidDeviceOwnerKioskModeWeblink() {
        return new Builder();
    }

    public static final class Builder {
        private String label;
        private String link;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Display name for weblink”</i>
         * 
         * @param label
         *            value of {@code label} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder label(String label) {
            this.label = label;
            this.changedFields = changedFields.add("label");
            return this;
        }

        /**
         * <i>“Link for weblink”</i>
         * 
         * @param link
         *            value of {@code link} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder link(String link) {
            this.link = link;
            this.changedFields = changedFields.add("link");
            return this;
        }

        public AndroidDeviceOwnerKioskModeWeblink build() {
            AndroidDeviceOwnerKioskModeWeblink _x = new AndroidDeviceOwnerKioskModeWeblink();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.androidDeviceOwnerKioskModeWeblink";
            _x.label = label;
            _x.link = link;
            return _x;
        }
    }

    private AndroidDeviceOwnerKioskModeWeblink _copy() {
        AndroidDeviceOwnerKioskModeWeblink _x = new AndroidDeviceOwnerKioskModeWeblink();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.label = label;
        _x.link = link;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AndroidDeviceOwnerKioskModeWeblink[");
        b.append("label=");
        b.append(this.label);
        b.append(", ");
        b.append("link=");
        b.append(this.link);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
