package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "identityProvider", 
    "key", 
    "type"})
@JsonInclude(Include.NON_NULL)
public class AlternativeSecurityId implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("identityProvider")
    protected String identityProvider;

    @JsonProperty("key")
    protected byte[] key;

    @JsonProperty("type")
    protected Integer type;

    protected AlternativeSecurityId() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.alternativeSecurityId";
    }

    @Property(name="identityProvider")
    @JsonIgnore
    public Optional<String> getIdentityProvider() {
        return Optional.ofNullable(identityProvider);
    }

    public AlternativeSecurityId withIdentityProvider(String identityProvider) {
        AlternativeSecurityId _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.alternativeSecurityId");
        _x.identityProvider = identityProvider;
        return _x;
    }

    @Property(name="key")
    @JsonIgnore
    public Optional<byte[]> getKey() {
        return Optional.ofNullable(key);
    }

    public AlternativeSecurityId withKey(byte[] key) {
        AlternativeSecurityId _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.alternativeSecurityId");
        _x.key = key;
        return _x;
    }

    @Property(name="type")
    @JsonIgnore
    public Optional<Integer> getType() {
        return Optional.ofNullable(type);
    }

    public AlternativeSecurityId withType(Integer type) {
        AlternativeSecurityId _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.alternativeSecurityId");
        _x.type = type;
        return _x;
    }

    public AlternativeSecurityId withUnmappedField(String name, Object value) {
        AlternativeSecurityId _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String identityProvider;
        private byte[] key;
        private Integer type;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder identityProvider(String identityProvider) {
            this.identityProvider = identityProvider;
            this.changedFields = changedFields.add("identityProvider");
            return this;
        }

        public Builder key(byte[] key) {
            this.key = key;
            this.changedFields = changedFields.add("key");
            return this;
        }

        public Builder type(Integer type) {
            this.type = type;
            this.changedFields = changedFields.add("type");
            return this;
        }

        public AlternativeSecurityId build() {
            AlternativeSecurityId _x = new AlternativeSecurityId();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.alternativeSecurityId";
            _x.identityProvider = identityProvider;
            _x.key = key;
            _x.type = type;
            return _x;
        }
    }

    private AlternativeSecurityId _copy() {
        AlternativeSecurityId _x = new AlternativeSecurityId();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.identityProvider = identityProvider;
        _x.key = key;
        _x.type = type;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AlternativeSecurityId[");
        b.append("identityProvider=");
        b.append(this.identityProvider);
        b.append(", ");
        b.append("key=");
        b.append(this.key);
        b.append(", ");
        b.append("type=");
        b.append(this.type);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
