package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "length", 
    "offset", 
    "suggestion"})
@JsonInclude(Include.NON_NULL)
public class AlteredQueryToken implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("length")
    protected Integer length;

    @JsonProperty("offset")
    protected Integer offset;

    @JsonProperty("suggestion")
    protected String suggestion;

    protected AlteredQueryToken() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.alteredQueryToken";
    }

    @Property(name="length")
    @JsonIgnore
    public Optional<Integer> getLength() {
        return Optional.ofNullable(length);
    }

    public AlteredQueryToken withLength(Integer length) {
        AlteredQueryToken _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.alteredQueryToken");
        _x.length = length;
        return _x;
    }

    @Property(name="offset")
    @JsonIgnore
    public Optional<Integer> getOffset() {
        return Optional.ofNullable(offset);
    }

    public AlteredQueryToken withOffset(Integer offset) {
        AlteredQueryToken _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.alteredQueryToken");
        _x.offset = offset;
        return _x;
    }

    @Property(name="suggestion")
    @JsonIgnore
    public Optional<String> getSuggestion() {
        return Optional.ofNullable(suggestion);
    }

    public AlteredQueryToken withSuggestion(String suggestion) {
        AlteredQueryToken _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.alteredQueryToken");
        _x.suggestion = suggestion;
        return _x;
    }

    public AlteredQueryToken withUnmappedField(String name, Object value) {
        AlteredQueryToken _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer length;
        private Integer offset;
        private String suggestion;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder length(Integer length) {
            this.length = length;
            this.changedFields = changedFields.add("length");
            return this;
        }

        public Builder offset(Integer offset) {
            this.offset = offset;
            this.changedFields = changedFields.add("offset");
            return this;
        }

        public Builder suggestion(String suggestion) {
            this.suggestion = suggestion;
            this.changedFields = changedFields.add("suggestion");
            return this;
        }

        public AlteredQueryToken build() {
            AlteredQueryToken _x = new AlteredQueryToken();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.alteredQueryToken";
            _x.length = length;
            _x.offset = offset;
            _x.suggestion = suggestion;
            return _x;
        }
    }

    private AlteredQueryToken _copy() {
        AlteredQueryToken _x = new AlteredQueryToken();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.length = length;
        _x.offset = offset;
        _x.suggestion = suggestion;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AlteredQueryToken[");
        b.append("length=");
        b.append(this.length);
        b.append(", ");
        b.append("offset=");
        b.append(this.offset);
        b.append(", ");
        b.append("suggestion=");
        b.append(this.suggestion);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
