package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "detectionType", 
    "method", 
    "name"})
@JsonInclude(Include.NON_NULL)
public class AlertDetection implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("detectionType")
    protected String detectionType;

    @JsonProperty("method")
    protected String method;

    @JsonProperty("name")
    protected String name;

    protected AlertDetection() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.alertDetection";
    }

    @Property(name="detectionType")
    @JsonIgnore
    public Optional<String> getDetectionType() {
        return Optional.ofNullable(detectionType);
    }

    public AlertDetection withDetectionType(String detectionType) {
        AlertDetection _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.alertDetection");
        _x.detectionType = detectionType;
        return _x;
    }

    @Property(name="method")
    @JsonIgnore
    public Optional<String> getMethod() {
        return Optional.ofNullable(method);
    }

    public AlertDetection withMethod(String method) {
        AlertDetection _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.alertDetection");
        _x.method = method;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public AlertDetection withName(String name) {
        AlertDetection _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.alertDetection");
        _x.name = name;
        return _x;
    }

    public AlertDetection withUnmappedField(String name, Object value) {
        AlertDetection _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String detectionType;
        private String method;
        private String name;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder detectionType(String detectionType) {
            this.detectionType = detectionType;
            this.changedFields = changedFields.add("detectionType");
            return this;
        }

        public Builder method(String method) {
            this.method = method;
            this.changedFields = changedFields.add("method");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public AlertDetection build() {
            AlertDetection _x = new AlertDetection();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.alertDetection";
            _x.detectionType = detectionType;
            _x.method = method;
            _x.name = name;
            return _x;
        }
    }

    private AlertDetection _copy() {
        AlertDetection _x = new AlertDetection();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.detectionType = detectionType;
        _x.method = method;
        _x.name = name;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AlertDetection[");
        b.append("detectionType=");
        b.append(this.detectionType);
        b.append(", ");
        b.append("method=");
        b.append(this.method);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
