package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "applyActions", 
    "autoApplyDecisionsEnabled", 
    "decisionHistoriesForReviewersEnabled", 
    "defaultDecision", 
    "defaultDecisionEnabled", 
    "instanceDurationInDays", 
    "justificationRequiredOnApproval", 
    "mailNotificationsEnabled", 
    "recommendationInsightSettings", 
    "recommendationLookBackDuration", 
    "recommendationsEnabled", 
    "recurrence", 
    "reminderNotificationsEnabled"})
@JsonInclude(Include.NON_NULL)
public class AccessReviewScheduleSettings implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("applyActions")
    protected List<AccessReviewApplyAction> applyActions;

    @JsonProperty("applyActions@nextLink")
    protected String applyActionsNextLink;

    @JsonProperty("autoApplyDecisionsEnabled")
    protected Boolean autoApplyDecisionsEnabled;

    @JsonProperty("decisionHistoriesForReviewersEnabled")
    protected Boolean decisionHistoriesForReviewersEnabled;

    @JsonProperty("defaultDecision")
    protected String defaultDecision;

    @JsonProperty("defaultDecisionEnabled")
    protected Boolean defaultDecisionEnabled;

    @JsonProperty("instanceDurationInDays")
    protected Integer instanceDurationInDays;

    @JsonProperty("justificationRequiredOnApproval")
    protected Boolean justificationRequiredOnApproval;

    @JsonProperty("mailNotificationsEnabled")
    protected Boolean mailNotificationsEnabled;

    @JsonProperty("recommendationInsightSettings")
    protected List<AccessReviewRecommendationInsightSetting> recommendationInsightSettings;

    @JsonProperty("recommendationInsightSettings@nextLink")
    protected String recommendationInsightSettingsNextLink;

    @JsonProperty("recommendationLookBackDuration")
    protected Duration recommendationLookBackDuration;

    @JsonProperty("recommendationsEnabled")
    protected Boolean recommendationsEnabled;

    @JsonProperty("recurrence")
    protected PatternedRecurrence recurrence;

    @JsonProperty("reminderNotificationsEnabled")
    protected Boolean reminderNotificationsEnabled;

    protected AccessReviewScheduleSettings() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.accessReviewScheduleSettings";
    }

    @Property(name="applyActions")
    @JsonIgnore
    public CollectionPage<AccessReviewApplyAction> getApplyActions() {
        return new CollectionPage<AccessReviewApplyAction>(contextPath, AccessReviewApplyAction.class, this.applyActions, Optional.ofNullable(applyActionsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="applyActions")
    @JsonIgnore
    public CollectionPage<AccessReviewApplyAction> getApplyActions(HttpRequestOptions options) {
        return new CollectionPage<AccessReviewApplyAction>(contextPath, AccessReviewApplyAction.class, this.applyActions, Optional.ofNullable(applyActionsNextLink), Collections.emptyList(), options);
    }

    @Property(name="autoApplyDecisionsEnabled")
    @JsonIgnore
    public Optional<Boolean> getAutoApplyDecisionsEnabled() {
        return Optional.ofNullable(autoApplyDecisionsEnabled);
    }

    public AccessReviewScheduleSettings withAutoApplyDecisionsEnabled(Boolean autoApplyDecisionsEnabled) {
        AccessReviewScheduleSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewScheduleSettings");
        _x.autoApplyDecisionsEnabled = autoApplyDecisionsEnabled;
        return _x;
    }

    @Property(name="decisionHistoriesForReviewersEnabled")
    @JsonIgnore
    public Optional<Boolean> getDecisionHistoriesForReviewersEnabled() {
        return Optional.ofNullable(decisionHistoriesForReviewersEnabled);
    }

    public AccessReviewScheduleSettings withDecisionHistoriesForReviewersEnabled(Boolean decisionHistoriesForReviewersEnabled) {
        AccessReviewScheduleSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewScheduleSettings");
        _x.decisionHistoriesForReviewersEnabled = decisionHistoriesForReviewersEnabled;
        return _x;
    }

    @Property(name="defaultDecision")
    @JsonIgnore
    public Optional<String> getDefaultDecision() {
        return Optional.ofNullable(defaultDecision);
    }

    public AccessReviewScheduleSettings withDefaultDecision(String defaultDecision) {
        AccessReviewScheduleSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewScheduleSettings");
        _x.defaultDecision = defaultDecision;
        return _x;
    }

    @Property(name="defaultDecisionEnabled")
    @JsonIgnore
    public Optional<Boolean> getDefaultDecisionEnabled() {
        return Optional.ofNullable(defaultDecisionEnabled);
    }

    public AccessReviewScheduleSettings withDefaultDecisionEnabled(Boolean defaultDecisionEnabled) {
        AccessReviewScheduleSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewScheduleSettings");
        _x.defaultDecisionEnabled = defaultDecisionEnabled;
        return _x;
    }

    @Property(name="instanceDurationInDays")
    @JsonIgnore
    public Optional<Integer> getInstanceDurationInDays() {
        return Optional.ofNullable(instanceDurationInDays);
    }

    public AccessReviewScheduleSettings withInstanceDurationInDays(Integer instanceDurationInDays) {
        AccessReviewScheduleSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewScheduleSettings");
        _x.instanceDurationInDays = instanceDurationInDays;
        return _x;
    }

    @Property(name="justificationRequiredOnApproval")
    @JsonIgnore
    public Optional<Boolean> getJustificationRequiredOnApproval() {
        return Optional.ofNullable(justificationRequiredOnApproval);
    }

    public AccessReviewScheduleSettings withJustificationRequiredOnApproval(Boolean justificationRequiredOnApproval) {
        AccessReviewScheduleSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewScheduleSettings");
        _x.justificationRequiredOnApproval = justificationRequiredOnApproval;
        return _x;
    }

    @Property(name="mailNotificationsEnabled")
    @JsonIgnore
    public Optional<Boolean> getMailNotificationsEnabled() {
        return Optional.ofNullable(mailNotificationsEnabled);
    }

    public AccessReviewScheduleSettings withMailNotificationsEnabled(Boolean mailNotificationsEnabled) {
        AccessReviewScheduleSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewScheduleSettings");
        _x.mailNotificationsEnabled = mailNotificationsEnabled;
        return _x;
    }

    @Property(name="recommendationInsightSettings")
    @JsonIgnore
    public CollectionPage<AccessReviewRecommendationInsightSetting> getRecommendationInsightSettings() {
        return new CollectionPage<AccessReviewRecommendationInsightSetting>(contextPath, AccessReviewRecommendationInsightSetting.class, this.recommendationInsightSettings, Optional.ofNullable(recommendationInsightSettingsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="recommendationInsightSettings")
    @JsonIgnore
    public CollectionPage<AccessReviewRecommendationInsightSetting> getRecommendationInsightSettings(HttpRequestOptions options) {
        return new CollectionPage<AccessReviewRecommendationInsightSetting>(contextPath, AccessReviewRecommendationInsightSetting.class, this.recommendationInsightSettings, Optional.ofNullable(recommendationInsightSettingsNextLink), Collections.emptyList(), options);
    }

    @Property(name="recommendationLookBackDuration")
    @JsonIgnore
    public Optional<Duration> getRecommendationLookBackDuration() {
        return Optional.ofNullable(recommendationLookBackDuration);
    }

    public AccessReviewScheduleSettings withRecommendationLookBackDuration(Duration recommendationLookBackDuration) {
        AccessReviewScheduleSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewScheduleSettings");
        _x.recommendationLookBackDuration = recommendationLookBackDuration;
        return _x;
    }

    @Property(name="recommendationsEnabled")
    @JsonIgnore
    public Optional<Boolean> getRecommendationsEnabled() {
        return Optional.ofNullable(recommendationsEnabled);
    }

    public AccessReviewScheduleSettings withRecommendationsEnabled(Boolean recommendationsEnabled) {
        AccessReviewScheduleSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewScheduleSettings");
        _x.recommendationsEnabled = recommendationsEnabled;
        return _x;
    }

    @Property(name="recurrence")
    @JsonIgnore
    public Optional<PatternedRecurrence> getRecurrence() {
        return Optional.ofNullable(recurrence);
    }

    public AccessReviewScheduleSettings withRecurrence(PatternedRecurrence recurrence) {
        AccessReviewScheduleSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewScheduleSettings");
        _x.recurrence = recurrence;
        return _x;
    }

    @Property(name="reminderNotificationsEnabled")
    @JsonIgnore
    public Optional<Boolean> getReminderNotificationsEnabled() {
        return Optional.ofNullable(reminderNotificationsEnabled);
    }

    public AccessReviewScheduleSettings withReminderNotificationsEnabled(Boolean reminderNotificationsEnabled) {
        AccessReviewScheduleSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewScheduleSettings");
        _x.reminderNotificationsEnabled = reminderNotificationsEnabled;
        return _x;
    }

    public AccessReviewScheduleSettings withUnmappedField(String name, Object value) {
        AccessReviewScheduleSettings _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<AccessReviewApplyAction> applyActions;
        private String applyActionsNextLink;
        private Boolean autoApplyDecisionsEnabled;
        private Boolean decisionHistoriesForReviewersEnabled;
        private String defaultDecision;
        private Boolean defaultDecisionEnabled;
        private Integer instanceDurationInDays;
        private Boolean justificationRequiredOnApproval;
        private Boolean mailNotificationsEnabled;
        private List<AccessReviewRecommendationInsightSetting> recommendationInsightSettings;
        private String recommendationInsightSettingsNextLink;
        private Duration recommendationLookBackDuration;
        private Boolean recommendationsEnabled;
        private PatternedRecurrence recurrence;
        private Boolean reminderNotificationsEnabled;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder applyActions(List<AccessReviewApplyAction> applyActions) {
            this.applyActions = applyActions;
            this.changedFields = changedFields.add("applyActions");
            return this;
        }

        public Builder applyActions(AccessReviewApplyAction... applyActions) {
            return applyActions(Arrays.asList(applyActions));
        }

        public Builder applyActionsNextLink(String applyActionsNextLink) {
            this.applyActionsNextLink = applyActionsNextLink;
            this.changedFields = changedFields.add("applyActions");
            return this;
        }

        public Builder autoApplyDecisionsEnabled(Boolean autoApplyDecisionsEnabled) {
            this.autoApplyDecisionsEnabled = autoApplyDecisionsEnabled;
            this.changedFields = changedFields.add("autoApplyDecisionsEnabled");
            return this;
        }

        public Builder decisionHistoriesForReviewersEnabled(Boolean decisionHistoriesForReviewersEnabled) {
            this.decisionHistoriesForReviewersEnabled = decisionHistoriesForReviewersEnabled;
            this.changedFields = changedFields.add("decisionHistoriesForReviewersEnabled");
            return this;
        }

        public Builder defaultDecision(String defaultDecision) {
            this.defaultDecision = defaultDecision;
            this.changedFields = changedFields.add("defaultDecision");
            return this;
        }

        public Builder defaultDecisionEnabled(Boolean defaultDecisionEnabled) {
            this.defaultDecisionEnabled = defaultDecisionEnabled;
            this.changedFields = changedFields.add("defaultDecisionEnabled");
            return this;
        }

        public Builder instanceDurationInDays(Integer instanceDurationInDays) {
            this.instanceDurationInDays = instanceDurationInDays;
            this.changedFields = changedFields.add("instanceDurationInDays");
            return this;
        }

        public Builder justificationRequiredOnApproval(Boolean justificationRequiredOnApproval) {
            this.justificationRequiredOnApproval = justificationRequiredOnApproval;
            this.changedFields = changedFields.add("justificationRequiredOnApproval");
            return this;
        }

        public Builder mailNotificationsEnabled(Boolean mailNotificationsEnabled) {
            this.mailNotificationsEnabled = mailNotificationsEnabled;
            this.changedFields = changedFields.add("mailNotificationsEnabled");
            return this;
        }

        public Builder recommendationInsightSettings(List<AccessReviewRecommendationInsightSetting> recommendationInsightSettings) {
            this.recommendationInsightSettings = recommendationInsightSettings;
            this.changedFields = changedFields.add("recommendationInsightSettings");
            return this;
        }

        public Builder recommendationInsightSettings(AccessReviewRecommendationInsightSetting... recommendationInsightSettings) {
            return recommendationInsightSettings(Arrays.asList(recommendationInsightSettings));
        }

        public Builder recommendationInsightSettingsNextLink(String recommendationInsightSettingsNextLink) {
            this.recommendationInsightSettingsNextLink = recommendationInsightSettingsNextLink;
            this.changedFields = changedFields.add("recommendationInsightSettings");
            return this;
        }

        public Builder recommendationLookBackDuration(Duration recommendationLookBackDuration) {
            this.recommendationLookBackDuration = recommendationLookBackDuration;
            this.changedFields = changedFields.add("recommendationLookBackDuration");
            return this;
        }

        public Builder recommendationsEnabled(Boolean recommendationsEnabled) {
            this.recommendationsEnabled = recommendationsEnabled;
            this.changedFields = changedFields.add("recommendationsEnabled");
            return this;
        }

        public Builder recurrence(PatternedRecurrence recurrence) {
            this.recurrence = recurrence;
            this.changedFields = changedFields.add("recurrence");
            return this;
        }

        public Builder reminderNotificationsEnabled(Boolean reminderNotificationsEnabled) {
            this.reminderNotificationsEnabled = reminderNotificationsEnabled;
            this.changedFields = changedFields.add("reminderNotificationsEnabled");
            return this;
        }

        public AccessReviewScheduleSettings build() {
            AccessReviewScheduleSettings _x = new AccessReviewScheduleSettings();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.accessReviewScheduleSettings";
            _x.applyActions = applyActions;
            _x.applyActionsNextLink = applyActionsNextLink;
            _x.autoApplyDecisionsEnabled = autoApplyDecisionsEnabled;
            _x.decisionHistoriesForReviewersEnabled = decisionHistoriesForReviewersEnabled;
            _x.defaultDecision = defaultDecision;
            _x.defaultDecisionEnabled = defaultDecisionEnabled;
            _x.instanceDurationInDays = instanceDurationInDays;
            _x.justificationRequiredOnApproval = justificationRequiredOnApproval;
            _x.mailNotificationsEnabled = mailNotificationsEnabled;
            _x.recommendationInsightSettings = recommendationInsightSettings;
            _x.recommendationInsightSettingsNextLink = recommendationInsightSettingsNextLink;
            _x.recommendationLookBackDuration = recommendationLookBackDuration;
            _x.recommendationsEnabled = recommendationsEnabled;
            _x.recurrence = recurrence;
            _x.reminderNotificationsEnabled = reminderNotificationsEnabled;
            return _x;
        }
    }

    private AccessReviewScheduleSettings _copy() {
        AccessReviewScheduleSettings _x = new AccessReviewScheduleSettings();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.applyActions = applyActions;
        _x.autoApplyDecisionsEnabled = autoApplyDecisionsEnabled;
        _x.decisionHistoriesForReviewersEnabled = decisionHistoriesForReviewersEnabled;
        _x.defaultDecision = defaultDecision;
        _x.defaultDecisionEnabled = defaultDecisionEnabled;
        _x.instanceDurationInDays = instanceDurationInDays;
        _x.justificationRequiredOnApproval = justificationRequiredOnApproval;
        _x.mailNotificationsEnabled = mailNotificationsEnabled;
        _x.recommendationInsightSettings = recommendationInsightSettings;
        _x.recommendationLookBackDuration = recommendationLookBackDuration;
        _x.recommendationsEnabled = recommendationsEnabled;
        _x.recurrence = recurrence;
        _x.reminderNotificationsEnabled = reminderNotificationsEnabled;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AccessReviewScheduleSettings[");
        b.append("applyActions=");
        b.append(this.applyActions);
        b.append(", ");
        b.append("autoApplyDecisionsEnabled=");
        b.append(this.autoApplyDecisionsEnabled);
        b.append(", ");
        b.append("decisionHistoriesForReviewersEnabled=");
        b.append(this.decisionHistoriesForReviewersEnabled);
        b.append(", ");
        b.append("defaultDecision=");
        b.append(this.defaultDecision);
        b.append(", ");
        b.append("defaultDecisionEnabled=");
        b.append(this.defaultDecisionEnabled);
        b.append(", ");
        b.append("instanceDurationInDays=");
        b.append(this.instanceDurationInDays);
        b.append(", ");
        b.append("justificationRequiredOnApproval=");
        b.append(this.justificationRequiredOnApproval);
        b.append(", ");
        b.append("mailNotificationsEnabled=");
        b.append(this.mailNotificationsEnabled);
        b.append(", ");
        b.append("recommendationInsightSettings=");
        b.append(this.recommendationInsightSettings);
        b.append(", ");
        b.append("recommendationLookBackDuration=");
        b.append(this.recommendationLookBackDuration);
        b.append(", ");
        b.append("recommendationsEnabled=");
        b.append(this.recommendationsEnabled);
        b.append(", ");
        b.append("recurrence=");
        b.append(this.recurrence);
        b.append(", ");
        b.append("reminderNotificationsEnabled=");
        b.append(this.reminderNotificationsEnabled);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
