package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "query", 
    "queryRoot", 
    "queryType"})
@JsonInclude(Include.NON_NULL)
public class AccessReviewReviewerScope extends AccessReviewScope implements ODataType {

    @JsonProperty("query")
    protected String query;

    @JsonProperty("queryRoot")
    protected String queryRoot;

    @JsonProperty("queryType")
    protected String queryType;

    protected AccessReviewReviewerScope() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.accessReviewReviewerScope";
    }

    @Property(name="query")
    @JsonIgnore
    public Optional<String> getQuery() {
        return Optional.ofNullable(query);
    }

    public AccessReviewReviewerScope withQuery(String query) {
        AccessReviewReviewerScope _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewReviewerScope");
        _x.query = query;
        return _x;
    }

    @Property(name="queryRoot")
    @JsonIgnore
    public Optional<String> getQueryRoot() {
        return Optional.ofNullable(queryRoot);
    }

    public AccessReviewReviewerScope withQueryRoot(String queryRoot) {
        AccessReviewReviewerScope _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewReviewerScope");
        _x.queryRoot = queryRoot;
        return _x;
    }

    @Property(name="queryType")
    @JsonIgnore
    public Optional<String> getQueryType() {
        return Optional.ofNullable(queryType);
    }

    public AccessReviewReviewerScope withQueryType(String queryType) {
        AccessReviewReviewerScope _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewReviewerScope");
        _x.queryType = queryType;
        return _x;
    }

    public AccessReviewReviewerScope withUnmappedField(String name, Object value) {
        AccessReviewReviewerScope _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAccessReviewReviewerScope() {
        return new Builder();
    }

    public static final class Builder {
        private String query;
        private String queryRoot;
        private String queryType;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder query(String query) {
            this.query = query;
            this.changedFields = changedFields.add("query");
            return this;
        }

        public Builder queryRoot(String queryRoot) {
            this.queryRoot = queryRoot;
            this.changedFields = changedFields.add("queryRoot");
            return this;
        }

        public Builder queryType(String queryType) {
            this.queryType = queryType;
            this.changedFields = changedFields.add("queryType");
            return this;
        }

        public AccessReviewReviewerScope build() {
            AccessReviewReviewerScope _x = new AccessReviewReviewerScope();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.accessReviewReviewerScope";
            _x.query = query;
            _x.queryRoot = queryRoot;
            _x.queryType = queryType;
            return _x;
        }
    }

    private AccessReviewReviewerScope _copy() {
        AccessReviewReviewerScope _x = new AccessReviewReviewerScope();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.query = query;
        _x.queryRoot = queryRoot;
        _x.queryType = queryType;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AccessReviewReviewerScope[");
        b.append("query=");
        b.append(this.query);
        b.append(", ");
        b.append("queryRoot=");
        b.append(this.queryRoot);
        b.append(", ");
        b.append("queryType=");
        b.append(this.queryType);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
