package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "durationInDays", 
    "recurrenceCount", 
    "recurrenceEndType", 
    "recurrenceType"})
@JsonInclude(Include.NON_NULL)
public class AccessReviewRecurrenceSettings implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("durationInDays")
    protected Integer durationInDays;

    @JsonProperty("recurrenceCount")
    protected Integer recurrenceCount;

    @JsonProperty("recurrenceEndType")
    protected String recurrenceEndType;

    @JsonProperty("recurrenceType")
    protected String recurrenceType;

    protected AccessReviewRecurrenceSettings() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.accessReviewRecurrenceSettings";
    }

    @Property(name="durationInDays")
    @JsonIgnore
    public Optional<Integer> getDurationInDays() {
        return Optional.ofNullable(durationInDays);
    }

    public AccessReviewRecurrenceSettings withDurationInDays(Integer durationInDays) {
        AccessReviewRecurrenceSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewRecurrenceSettings");
        _x.durationInDays = durationInDays;
        return _x;
    }

    @Property(name="recurrenceCount")
    @JsonIgnore
    public Optional<Integer> getRecurrenceCount() {
        return Optional.ofNullable(recurrenceCount);
    }

    public AccessReviewRecurrenceSettings withRecurrenceCount(Integer recurrenceCount) {
        AccessReviewRecurrenceSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewRecurrenceSettings");
        _x.recurrenceCount = recurrenceCount;
        return _x;
    }

    @Property(name="recurrenceEndType")
    @JsonIgnore
    public Optional<String> getRecurrenceEndType() {
        return Optional.ofNullable(recurrenceEndType);
    }

    public AccessReviewRecurrenceSettings withRecurrenceEndType(String recurrenceEndType) {
        AccessReviewRecurrenceSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewRecurrenceSettings");
        _x.recurrenceEndType = recurrenceEndType;
        return _x;
    }

    @Property(name="recurrenceType")
    @JsonIgnore
    public Optional<String> getRecurrenceType() {
        return Optional.ofNullable(recurrenceType);
    }

    public AccessReviewRecurrenceSettings withRecurrenceType(String recurrenceType) {
        AccessReviewRecurrenceSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewRecurrenceSettings");
        _x.recurrenceType = recurrenceType;
        return _x;
    }

    public AccessReviewRecurrenceSettings withUnmappedField(String name, Object value) {
        AccessReviewRecurrenceSettings _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer durationInDays;
        private Integer recurrenceCount;
        private String recurrenceEndType;
        private String recurrenceType;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder durationInDays(Integer durationInDays) {
            this.durationInDays = durationInDays;
            this.changedFields = changedFields.add("durationInDays");
            return this;
        }

        public Builder recurrenceCount(Integer recurrenceCount) {
            this.recurrenceCount = recurrenceCount;
            this.changedFields = changedFields.add("recurrenceCount");
            return this;
        }

        public Builder recurrenceEndType(String recurrenceEndType) {
            this.recurrenceEndType = recurrenceEndType;
            this.changedFields = changedFields.add("recurrenceEndType");
            return this;
        }

        public Builder recurrenceType(String recurrenceType) {
            this.recurrenceType = recurrenceType;
            this.changedFields = changedFields.add("recurrenceType");
            return this;
        }

        public AccessReviewRecurrenceSettings build() {
            AccessReviewRecurrenceSettings _x = new AccessReviewRecurrenceSettings();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.accessReviewRecurrenceSettings";
            _x.durationInDays = durationInDays;
            _x.recurrenceCount = recurrenceCount;
            _x.recurrenceEndType = recurrenceEndType;
            _x.recurrenceType = recurrenceType;
            return _x;
        }
    }

    private AccessReviewRecurrenceSettings _copy() {
        AccessReviewRecurrenceSettings _x = new AccessReviewRecurrenceSettings();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.durationInDays = durationInDays;
        _x.recurrenceCount = recurrenceCount;
        _x.recurrenceEndType = recurrenceEndType;
        _x.recurrenceType = recurrenceType;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AccessReviewRecurrenceSettings[");
        b.append("durationInDays=");
        b.append(this.durationInDays);
        b.append(", ");
        b.append("recurrenceCount=");
        b.append(this.recurrenceCount);
        b.append(", ");
        b.append("recurrenceEndType=");
        b.append(this.recurrenceEndType);
        b.append(", ");
        b.append("recurrenceType=");
        b.append(this.recurrenceType);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
