package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "notificationRecipientScope", 
    "notificationTemplateType"})
@JsonInclude(Include.NON_NULL)
public class AccessReviewNotificationRecipientItem implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("notificationRecipientScope")
    protected AccessReviewNotificationRecipientScope notificationRecipientScope;

    @JsonProperty("notificationTemplateType")
    protected String notificationTemplateType;

    protected AccessReviewNotificationRecipientItem() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.accessReviewNotificationRecipientItem";
    }

    @Property(name="notificationRecipientScope")
    @JsonIgnore
    public Optional<AccessReviewNotificationRecipientScope> getNotificationRecipientScope() {
        return Optional.ofNullable(notificationRecipientScope);
    }

    public AccessReviewNotificationRecipientItem withNotificationRecipientScope(AccessReviewNotificationRecipientScope notificationRecipientScope) {
        AccessReviewNotificationRecipientItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewNotificationRecipientItem");
        _x.notificationRecipientScope = notificationRecipientScope;
        return _x;
    }

    @Property(name="notificationTemplateType")
    @JsonIgnore
    public Optional<String> getNotificationTemplateType() {
        return Optional.ofNullable(notificationTemplateType);
    }

    public AccessReviewNotificationRecipientItem withNotificationTemplateType(String notificationTemplateType) {
        AccessReviewNotificationRecipientItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewNotificationRecipientItem");
        _x.notificationTemplateType = notificationTemplateType;
        return _x;
    }

    public AccessReviewNotificationRecipientItem withUnmappedField(String name, Object value) {
        AccessReviewNotificationRecipientItem _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private AccessReviewNotificationRecipientScope notificationRecipientScope;
        private String notificationTemplateType;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder notificationRecipientScope(AccessReviewNotificationRecipientScope notificationRecipientScope) {
            this.notificationRecipientScope = notificationRecipientScope;
            this.changedFields = changedFields.add("notificationRecipientScope");
            return this;
        }

        public Builder notificationTemplateType(String notificationTemplateType) {
            this.notificationTemplateType = notificationTemplateType;
            this.changedFields = changedFields.add("notificationTemplateType");
            return this;
        }

        public AccessReviewNotificationRecipientItem build() {
            AccessReviewNotificationRecipientItem _x = new AccessReviewNotificationRecipientItem();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.accessReviewNotificationRecipientItem";
            _x.notificationRecipientScope = notificationRecipientScope;
            _x.notificationTemplateType = notificationTemplateType;
            return _x;
        }
    }

    private AccessReviewNotificationRecipientItem _copy() {
        AccessReviewNotificationRecipientItem _x = new AccessReviewNotificationRecipientItem();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.notificationRecipientScope = notificationRecipientScope;
        _x.notificationTemplateType = notificationTemplateType;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AccessReviewNotificationRecipientItem[");
        b.append("notificationRecipientScope=");
        b.append(this.notificationRecipientScope);
        b.append(", ");
        b.append("notificationTemplateType=");
        b.append(this.notificationTemplateType);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
