package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "userDisplayName", 
    "userId", 
    "userPrincipalName"})
@JsonInclude(Include.NON_NULL)
public class AccessReviewInstanceDecisionItemUserTarget extends AccessReviewInstanceDecisionItemTarget implements ODataType {

    @JsonProperty("userDisplayName")
    protected String userDisplayName;

    @JsonProperty("userId")
    protected String userId;

    @JsonProperty("userPrincipalName")
    protected String userPrincipalName;

    protected AccessReviewInstanceDecisionItemUserTarget() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.accessReviewInstanceDecisionItemUserTarget";
    }

    @Property(name="userDisplayName")
    @JsonIgnore
    public Optional<String> getUserDisplayName() {
        return Optional.ofNullable(userDisplayName);
    }

    public AccessReviewInstanceDecisionItemUserTarget withUserDisplayName(String userDisplayName) {
        AccessReviewInstanceDecisionItemUserTarget _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewInstanceDecisionItemUserTarget");
        _x.userDisplayName = userDisplayName;
        return _x;
    }

    @Property(name="userId")
    @JsonIgnore
    public Optional<String> getUserId() {
        return Optional.ofNullable(userId);
    }

    public AccessReviewInstanceDecisionItemUserTarget withUserId(String userId) {
        AccessReviewInstanceDecisionItemUserTarget _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewInstanceDecisionItemUserTarget");
        _x.userId = userId;
        return _x;
    }

    @Property(name="userPrincipalName")
    @JsonIgnore
    public Optional<String> getUserPrincipalName() {
        return Optional.ofNullable(userPrincipalName);
    }

    public AccessReviewInstanceDecisionItemUserTarget withUserPrincipalName(String userPrincipalName) {
        AccessReviewInstanceDecisionItemUserTarget _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewInstanceDecisionItemUserTarget");
        _x.userPrincipalName = userPrincipalName;
        return _x;
    }

    public AccessReviewInstanceDecisionItemUserTarget withUnmappedField(String name, Object value) {
        AccessReviewInstanceDecisionItemUserTarget _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAccessReviewInstanceDecisionItemUserTarget() {
        return new Builder();
    }

    public static final class Builder {
        private String userDisplayName;
        private String userId;
        private String userPrincipalName;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder userDisplayName(String userDisplayName) {
            this.userDisplayName = userDisplayName;
            this.changedFields = changedFields.add("userDisplayName");
            return this;
        }

        public Builder userId(String userId) {
            this.userId = userId;
            this.changedFields = changedFields.add("userId");
            return this;
        }

        public Builder userPrincipalName(String userPrincipalName) {
            this.userPrincipalName = userPrincipalName;
            this.changedFields = changedFields.add("userPrincipalName");
            return this;
        }

        public AccessReviewInstanceDecisionItemUserTarget build() {
            AccessReviewInstanceDecisionItemUserTarget _x = new AccessReviewInstanceDecisionItemUserTarget();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.accessReviewInstanceDecisionItemUserTarget";
            _x.userDisplayName = userDisplayName;
            _x.userId = userId;
            _x.userPrincipalName = userPrincipalName;
            return _x;
        }
    }

    private AccessReviewInstanceDecisionItemUserTarget _copy() {
        AccessReviewInstanceDecisionItemUserTarget _x = new AccessReviewInstanceDecisionItemUserTarget();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.userDisplayName = userDisplayName;
        _x.userId = userId;
        _x.userPrincipalName = userPrincipalName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AccessReviewInstanceDecisionItemUserTarget[");
        b.append("userDisplayName=");
        b.append(this.userDisplayName);
        b.append(", ");
        b.append("userId=");
        b.append(this.userId);
        b.append(", ");
        b.append("userPrincipalName=");
        b.append(this.userPrincipalName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
