package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "accessPackageDisplayName", 
    "accessPackageId"})
@JsonInclude(Include.NON_NULL)
public class AccessReviewInstanceDecisionItemAccessPackageAssignmentPolicyResource extends AccessReviewInstanceDecisionItemResource implements ODataType {

    @JsonProperty("accessPackageDisplayName")
    protected String accessPackageDisplayName;

    @JsonProperty("accessPackageId")
    protected String accessPackageId;

    protected AccessReviewInstanceDecisionItemAccessPackageAssignmentPolicyResource() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.accessReviewInstanceDecisionItemAccessPackageAssignmentPolicyResource";
    }

    @Property(name="accessPackageDisplayName")
    @JsonIgnore
    public Optional<String> getAccessPackageDisplayName() {
        return Optional.ofNullable(accessPackageDisplayName);
    }

    public AccessReviewInstanceDecisionItemAccessPackageAssignmentPolicyResource withAccessPackageDisplayName(String accessPackageDisplayName) {
        AccessReviewInstanceDecisionItemAccessPackageAssignmentPolicyResource _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewInstanceDecisionItemAccessPackageAssignmentPolicyResource");
        _x.accessPackageDisplayName = accessPackageDisplayName;
        return _x;
    }

    @Property(name="accessPackageId")
    @JsonIgnore
    public Optional<String> getAccessPackageId() {
        return Optional.ofNullable(accessPackageId);
    }

    public AccessReviewInstanceDecisionItemAccessPackageAssignmentPolicyResource withAccessPackageId(String accessPackageId) {
        AccessReviewInstanceDecisionItemAccessPackageAssignmentPolicyResource _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewInstanceDecisionItemAccessPackageAssignmentPolicyResource");
        _x.accessPackageId = accessPackageId;
        return _x;
    }

    public AccessReviewInstanceDecisionItemAccessPackageAssignmentPolicyResource withUnmappedField(String name, Object value) {
        AccessReviewInstanceDecisionItemAccessPackageAssignmentPolicyResource _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAccessReviewInstanceDecisionItemAccessPackageAssignmentPolicyResource() {
        return new Builder();
    }

    public static final class Builder {
        private String displayName;
        private String id;
        private String type;
        private String accessPackageDisplayName;
        private String accessPackageId;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            this.changedFields = changedFields.add("type");
            return this;
        }

        public Builder accessPackageDisplayName(String accessPackageDisplayName) {
            this.accessPackageDisplayName = accessPackageDisplayName;
            this.changedFields = changedFields.add("accessPackageDisplayName");
            return this;
        }

        public Builder accessPackageId(String accessPackageId) {
            this.accessPackageId = accessPackageId;
            this.changedFields = changedFields.add("accessPackageId");
            return this;
        }

        public AccessReviewInstanceDecisionItemAccessPackageAssignmentPolicyResource build() {
            AccessReviewInstanceDecisionItemAccessPackageAssignmentPolicyResource _x = new AccessReviewInstanceDecisionItemAccessPackageAssignmentPolicyResource();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.accessReviewInstanceDecisionItemAccessPackageAssignmentPolicyResource";
            _x.displayName = displayName;
            _x.id = id;
            _x.type = type;
            _x.accessPackageDisplayName = accessPackageDisplayName;
            _x.accessPackageId = accessPackageId;
            return _x;
        }
    }

    private AccessReviewInstanceDecisionItemAccessPackageAssignmentPolicyResource _copy() {
        AccessReviewInstanceDecisionItemAccessPackageAssignmentPolicyResource _x = new AccessReviewInstanceDecisionItemAccessPackageAssignmentPolicyResource();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.displayName = displayName;
        _x.id = id;
        _x.type = type;
        _x.accessPackageDisplayName = accessPackageDisplayName;
        _x.accessPackageId = accessPackageId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AccessReviewInstanceDecisionItemAccessPackageAssignmentPolicyResource[");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("type=");
        b.append(this.type);
        b.append(", ");
        b.append("accessPackageDisplayName=");
        b.append(this.accessPackageDisplayName);
        b.append(", ");
        b.append("accessPackageId=");
        b.append(this.accessPackageId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
