package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "recurrence", 
    "reportRange"})
@JsonInclude(Include.NON_NULL)
public class AccessReviewHistoryScheduleSettings implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("recurrence")
    protected PatternedRecurrence recurrence;

    @JsonProperty("reportRange")
    protected String reportRange;

    protected AccessReviewHistoryScheduleSettings() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.accessReviewHistoryScheduleSettings";
    }

    @Property(name="recurrence")
    @JsonIgnore
    public Optional<PatternedRecurrence> getRecurrence() {
        return Optional.ofNullable(recurrence);
    }

    public AccessReviewHistoryScheduleSettings withRecurrence(PatternedRecurrence recurrence) {
        AccessReviewHistoryScheduleSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewHistoryScheduleSettings");
        _x.recurrence = recurrence;
        return _x;
    }

    @Property(name="reportRange")
    @JsonIgnore
    public Optional<String> getReportRange() {
        return Optional.ofNullable(reportRange);
    }

    public AccessReviewHistoryScheduleSettings withReportRange(String reportRange) {
        AccessReviewHistoryScheduleSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewHistoryScheduleSettings");
        _x.reportRange = reportRange;
        return _x;
    }

    public AccessReviewHistoryScheduleSettings withUnmappedField(String name, Object value) {
        AccessReviewHistoryScheduleSettings _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private PatternedRecurrence recurrence;
        private String reportRange;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder recurrence(PatternedRecurrence recurrence) {
            this.recurrence = recurrence;
            this.changedFields = changedFields.add("recurrence");
            return this;
        }

        public Builder reportRange(String reportRange) {
            this.reportRange = reportRange;
            this.changedFields = changedFields.add("reportRange");
            return this;
        }

        public AccessReviewHistoryScheduleSettings build() {
            AccessReviewHistoryScheduleSettings _x = new AccessReviewHistoryScheduleSettings();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.accessReviewHistoryScheduleSettings";
            _x.recurrence = recurrence;
            _x.reportRange = reportRange;
            return _x;
        }
    }

    private AccessReviewHistoryScheduleSettings _copy() {
        AccessReviewHistoryScheduleSettings _x = new AccessReviewHistoryScheduleSettings();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.recurrence = recurrence;
        _x.reportRange = reportRange;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AccessReviewHistoryScheduleSettings[");
        b.append("recurrence=");
        b.append(this.recurrence);
        b.append(", ");
        b.append("reportRange=");
        b.append(this.reportRange);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
