package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;

@JsonPropertyOrder({
    "@odata.type"})
@JsonInclude(Include.NON_NULL)
public class AccessReviewError extends GenericError implements ODataType {

    protected AccessReviewError() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.accessReviewError";
    }

    public AccessReviewError withUnmappedField(String name, Object value) {
        AccessReviewError _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAccessReviewError() {
        return new Builder();
    }

    public static final class Builder {
        private String code;
        private String message;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder code(String code) {
            this.code = code;
            this.changedFields = changedFields.add("code");
            return this;
        }

        public Builder message(String message) {
            this.message = message;
            this.changedFields = changedFields.add("message");
            return this;
        }

        public AccessReviewError build() {
            AccessReviewError _x = new AccessReviewError();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.accessReviewError";
            _x.code = code;
            _x.message = message;
            return _x;
        }
    }

    private AccessReviewError _copy() {
        AccessReviewError _x = new AccessReviewError();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.code = code;
        _x.message = message;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AccessReviewError[");
        b.append("code=");
        b.append(this.code);
        b.append(", ");
        b.append("message=");
        b.append(this.message);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
