package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "isSingleLineQuestion"})
@JsonInclude(Include.NON_NULL)
public class AccessPackageTextInputQuestion extends AccessPackageQuestion implements ODataType {

    @JsonProperty("isSingleLineQuestion")
    protected Boolean isSingleLineQuestion;

    protected AccessPackageTextInputQuestion() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.accessPackageTextInputQuestion";
    }

    @Property(name="isSingleLineQuestion")
    @JsonIgnore
    public Optional<Boolean> getIsSingleLineQuestion() {
        return Optional.ofNullable(isSingleLineQuestion);
    }

    public AccessPackageTextInputQuestion withIsSingleLineQuestion(Boolean isSingleLineQuestion) {
        AccessPackageTextInputQuestion _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageTextInputQuestion");
        _x.isSingleLineQuestion = isSingleLineQuestion;
        return _x;
    }

    public AccessPackageTextInputQuestion withUnmappedField(String name, Object value) {
        AccessPackageTextInputQuestion _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAccessPackageTextInputQuestion() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Boolean isAnswerEditable;
        private Boolean isRequired;
        private Integer sequence;
        private AccessPackageLocalizedContent text;
        private Boolean isSingleLineQuestion;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder isAnswerEditable(Boolean isAnswerEditable) {
            this.isAnswerEditable = isAnswerEditable;
            this.changedFields = changedFields.add("isAnswerEditable");
            return this;
        }

        public Builder isRequired(Boolean isRequired) {
            this.isRequired = isRequired;
            this.changedFields = changedFields.add("isRequired");
            return this;
        }

        public Builder sequence(Integer sequence) {
            this.sequence = sequence;
            this.changedFields = changedFields.add("sequence");
            return this;
        }

        public Builder text(AccessPackageLocalizedContent text) {
            this.text = text;
            this.changedFields = changedFields.add("text");
            return this;
        }

        public Builder isSingleLineQuestion(Boolean isSingleLineQuestion) {
            this.isSingleLineQuestion = isSingleLineQuestion;
            this.changedFields = changedFields.add("isSingleLineQuestion");
            return this;
        }

        public AccessPackageTextInputQuestion build() {
            AccessPackageTextInputQuestion _x = new AccessPackageTextInputQuestion();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.accessPackageTextInputQuestion";
            _x.id = id;
            _x.isAnswerEditable = isAnswerEditable;
            _x.isRequired = isRequired;
            _x.sequence = sequence;
            _x.text = text;
            _x.isSingleLineQuestion = isSingleLineQuestion;
            return _x;
        }
    }

    private AccessPackageTextInputQuestion _copy() {
        AccessPackageTextInputQuestion _x = new AccessPackageTextInputQuestion();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.isAnswerEditable = isAnswerEditable;
        _x.isRequired = isRequired;
        _x.sequence = sequence;
        _x.text = text;
        _x.isSingleLineQuestion = isSingleLineQuestion;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AccessPackageTextInputQuestion[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("isAnswerEditable=");
        b.append(this.isAnswerEditable);
        b.append(", ");
        b.append("isRequired=");
        b.append(this.isRequired);
        b.append(", ");
        b.append("sequence=");
        b.append(this.sequence);
        b.append(", ");
        b.append("text=");
        b.append(this.text);
        b.append(", ");
        b.append("isSingleLineQuestion=");
        b.append(this.isSingleLineQuestion);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
