package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "question"})
@JsonInclude(Include.NON_NULL)
public class AccessPackageResourceAttributeQuestion extends AccessPackageResourceAttributeSource implements ODataType {

    @JsonProperty("question")
    protected AccessPackageQuestion question;

    protected AccessPackageResourceAttributeQuestion() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.accessPackageResourceAttributeQuestion";
    }

    @Property(name="question")
    @JsonIgnore
    public Optional<AccessPackageQuestion> getQuestion() {
        return Optional.ofNullable(question);
    }

    public AccessPackageResourceAttributeQuestion withQuestion(AccessPackageQuestion question) {
        AccessPackageResourceAttributeQuestion _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageResourceAttributeQuestion");
        _x.question = question;
        return _x;
    }

    public AccessPackageResourceAttributeQuestion withUnmappedField(String name, Object value) {
        AccessPackageResourceAttributeQuestion _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAccessPackageResourceAttributeQuestion() {
        return new Builder();
    }

    public static final class Builder {
        private AccessPackageQuestion question;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder question(AccessPackageQuestion question) {
            this.question = question;
            this.changedFields = changedFields.add("question");
            return this;
        }

        public AccessPackageResourceAttributeQuestion build() {
            AccessPackageResourceAttributeQuestion _x = new AccessPackageResourceAttributeQuestion();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.accessPackageResourceAttributeQuestion";
            _x.question = question;
            return _x;
        }
    }

    private AccessPackageResourceAttributeQuestion _copy() {
        AccessPackageResourceAttributeQuestion _x = new AccessPackageResourceAttributeQuestion();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.question = question;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AccessPackageResourceAttributeQuestion[");
        b.append("question=");
        b.append(this.question);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
