package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "allowsMultipleSelection", 
    "choices"})
@JsonInclude(Include.NON_NULL)
public class AccessPackageMultipleChoiceQuestion extends AccessPackageQuestion implements ODataType {

    @JsonProperty("allowsMultipleSelection")
    protected Boolean allowsMultipleSelection;

    @JsonProperty("choices")
    protected List<AccessPackageAnswerChoice> choices;

    @JsonProperty("choices@nextLink")
    protected String choicesNextLink;

    protected AccessPackageMultipleChoiceQuestion() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.accessPackageMultipleChoiceQuestion";
    }

    @Property(name="allowsMultipleSelection")
    @JsonIgnore
    public Optional<Boolean> getAllowsMultipleSelection() {
        return Optional.ofNullable(allowsMultipleSelection);
    }

    public AccessPackageMultipleChoiceQuestion withAllowsMultipleSelection(Boolean allowsMultipleSelection) {
        AccessPackageMultipleChoiceQuestion _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageMultipleChoiceQuestion");
        _x.allowsMultipleSelection = allowsMultipleSelection;
        return _x;
    }

    @Property(name="choices")
    @JsonIgnore
    public CollectionPage<AccessPackageAnswerChoice> getChoices() {
        return new CollectionPage<AccessPackageAnswerChoice>(contextPath, AccessPackageAnswerChoice.class, this.choices, Optional.ofNullable(choicesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="choices")
    @JsonIgnore
    public CollectionPage<AccessPackageAnswerChoice> getChoices(HttpRequestOptions options) {
        return new CollectionPage<AccessPackageAnswerChoice>(contextPath, AccessPackageAnswerChoice.class, this.choices, Optional.ofNullable(choicesNextLink), Collections.emptyList(), options);
    }

    public AccessPackageMultipleChoiceQuestion withUnmappedField(String name, Object value) {
        AccessPackageMultipleChoiceQuestion _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAccessPackageMultipleChoiceQuestion() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Boolean isAnswerEditable;
        private Boolean isRequired;
        private Integer sequence;
        private AccessPackageLocalizedContent text;
        private Boolean allowsMultipleSelection;
        private List<AccessPackageAnswerChoice> choices;
        private String choicesNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder isAnswerEditable(Boolean isAnswerEditable) {
            this.isAnswerEditable = isAnswerEditable;
            this.changedFields = changedFields.add("isAnswerEditable");
            return this;
        }

        public Builder isRequired(Boolean isRequired) {
            this.isRequired = isRequired;
            this.changedFields = changedFields.add("isRequired");
            return this;
        }

        public Builder sequence(Integer sequence) {
            this.sequence = sequence;
            this.changedFields = changedFields.add("sequence");
            return this;
        }

        public Builder text(AccessPackageLocalizedContent text) {
            this.text = text;
            this.changedFields = changedFields.add("text");
            return this;
        }

        public Builder allowsMultipleSelection(Boolean allowsMultipleSelection) {
            this.allowsMultipleSelection = allowsMultipleSelection;
            this.changedFields = changedFields.add("allowsMultipleSelection");
            return this;
        }

        public Builder choices(List<AccessPackageAnswerChoice> choices) {
            this.choices = choices;
            this.changedFields = changedFields.add("choices");
            return this;
        }

        public Builder choices(AccessPackageAnswerChoice... choices) {
            return choices(Arrays.asList(choices));
        }

        public Builder choicesNextLink(String choicesNextLink) {
            this.choicesNextLink = choicesNextLink;
            this.changedFields = changedFields.add("choices");
            return this;
        }

        public AccessPackageMultipleChoiceQuestion build() {
            AccessPackageMultipleChoiceQuestion _x = new AccessPackageMultipleChoiceQuestion();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.accessPackageMultipleChoiceQuestion";
            _x.id = id;
            _x.isAnswerEditable = isAnswerEditable;
            _x.isRequired = isRequired;
            _x.sequence = sequence;
            _x.text = text;
            _x.allowsMultipleSelection = allowsMultipleSelection;
            _x.choices = choices;
            _x.choicesNextLink = choicesNextLink;
            return _x;
        }
    }

    private AccessPackageMultipleChoiceQuestion _copy() {
        AccessPackageMultipleChoiceQuestion _x = new AccessPackageMultipleChoiceQuestion();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.isAnswerEditable = isAnswerEditable;
        _x.isRequired = isRequired;
        _x.sequence = sequence;
        _x.text = text;
        _x.allowsMultipleSelection = allowsMultipleSelection;
        _x.choices = choices;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AccessPackageMultipleChoiceQuestion[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("isAnswerEditable=");
        b.append(this.isAnswerEditable);
        b.append(", ");
        b.append("isRequired=");
        b.append(this.isRequired);
        b.append(", ");
        b.append("sequence=");
        b.append(this.sequence);
        b.append(", ");
        b.append("text=");
        b.append(this.text);
        b.append(", ");
        b.append("allowsMultipleSelection=");
        b.append(this.allowsMultipleSelection);
        b.append(", ");
        b.append("choices=");
        b.append(this.choices);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
