package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "defaultText", 
    "localizedTexts"})
@JsonInclude(Include.NON_NULL)
public class AccessPackageLocalizedContent implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("defaultText")
    protected String defaultText;

    @JsonProperty("localizedTexts")
    protected List<AccessPackageLocalizedText> localizedTexts;

    @JsonProperty("localizedTexts@nextLink")
    protected String localizedTextsNextLink;

    protected AccessPackageLocalizedContent() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.accessPackageLocalizedContent";
    }

    @Property(name="defaultText")
    @JsonIgnore
    public Optional<String> getDefaultText() {
        return Optional.ofNullable(defaultText);
    }

    public AccessPackageLocalizedContent withDefaultText(String defaultText) {
        AccessPackageLocalizedContent _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageLocalizedContent");
        _x.defaultText = defaultText;
        return _x;
    }

    @Property(name="localizedTexts")
    @JsonIgnore
    public CollectionPage<AccessPackageLocalizedText> getLocalizedTexts() {
        return new CollectionPage<AccessPackageLocalizedText>(contextPath, AccessPackageLocalizedText.class, this.localizedTexts, Optional.ofNullable(localizedTextsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="localizedTexts")
    @JsonIgnore
    public CollectionPage<AccessPackageLocalizedText> getLocalizedTexts(HttpRequestOptions options) {
        return new CollectionPage<AccessPackageLocalizedText>(contextPath, AccessPackageLocalizedText.class, this.localizedTexts, Optional.ofNullable(localizedTextsNextLink), Collections.emptyList(), options);
    }

    public AccessPackageLocalizedContent withUnmappedField(String name, Object value) {
        AccessPackageLocalizedContent _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String defaultText;
        private List<AccessPackageLocalizedText> localizedTexts;
        private String localizedTextsNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder defaultText(String defaultText) {
            this.defaultText = defaultText;
            this.changedFields = changedFields.add("defaultText");
            return this;
        }

        public Builder localizedTexts(List<AccessPackageLocalizedText> localizedTexts) {
            this.localizedTexts = localizedTexts;
            this.changedFields = changedFields.add("localizedTexts");
            return this;
        }

        public Builder localizedTexts(AccessPackageLocalizedText... localizedTexts) {
            return localizedTexts(Arrays.asList(localizedTexts));
        }

        public Builder localizedTextsNextLink(String localizedTextsNextLink) {
            this.localizedTextsNextLink = localizedTextsNextLink;
            this.changedFields = changedFields.add("localizedTexts");
            return this;
        }

        public AccessPackageLocalizedContent build() {
            AccessPackageLocalizedContent _x = new AccessPackageLocalizedContent();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.accessPackageLocalizedContent";
            _x.defaultText = defaultText;
            _x.localizedTexts = localizedTexts;
            _x.localizedTextsNextLink = localizedTextsNextLink;
            return _x;
        }
    }

    private AccessPackageLocalizedContent _copy() {
        AccessPackageLocalizedContent _x = new AccessPackageLocalizedContent();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.defaultText = defaultText;
        _x.localizedTexts = localizedTexts;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AccessPackageLocalizedContent[");
        b.append("defaultText=");
        b.append(this.defaultText);
        b.append(", ");
        b.append("localizedTexts=");
        b.append(this.localizedTexts);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
