package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "existingAnswers", 
    "isApprovalRequired", 
    "isApprovalRequiredForExtension", 
    "isCustomAssignmentScheduleAllowed", 
    "isRequestorJustificationRequired", 
    "policyDescription", 
    "policyDisplayName", 
    "policyId", 
    "questions", 
    "schedule"})
@JsonInclude(Include.NON_NULL)
public class AccessPackageAssignmentRequestRequirements implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("existingAnswers")
    protected List<AccessPackageAnswer> existingAnswers;

    @JsonProperty("existingAnswers@nextLink")
    protected String existingAnswersNextLink;

    @JsonProperty("isApprovalRequired")
    protected Boolean isApprovalRequired;

    @JsonProperty("isApprovalRequiredForExtension")
    protected Boolean isApprovalRequiredForExtension;

    @JsonProperty("isCustomAssignmentScheduleAllowed")
    protected Boolean isCustomAssignmentScheduleAllowed;

    @JsonProperty("isRequestorJustificationRequired")
    protected Boolean isRequestorJustificationRequired;

    @JsonProperty("policyDescription")
    protected String policyDescription;

    @JsonProperty("policyDisplayName")
    protected String policyDisplayName;

    @JsonProperty("policyId")
    protected String policyId;

    @JsonProperty("questions")
    protected List<AccessPackageQuestion> questions;

    @JsonProperty("questions@nextLink")
    protected String questionsNextLink;

    @JsonProperty("schedule")
    protected RequestSchedule schedule;

    protected AccessPackageAssignmentRequestRequirements() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.accessPackageAssignmentRequestRequirements";
    }

    @Property(name="existingAnswers")
    @JsonIgnore
    public CollectionPage<AccessPackageAnswer> getExistingAnswers() {
        return new CollectionPage<AccessPackageAnswer>(contextPath, AccessPackageAnswer.class, this.existingAnswers, Optional.ofNullable(existingAnswersNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="existingAnswers")
    @JsonIgnore
    public CollectionPage<AccessPackageAnswer> getExistingAnswers(HttpRequestOptions options) {
        return new CollectionPage<AccessPackageAnswer>(contextPath, AccessPackageAnswer.class, this.existingAnswers, Optional.ofNullable(existingAnswersNextLink), Collections.emptyList(), options);
    }

    @Property(name="isApprovalRequired")
    @JsonIgnore
    public Optional<Boolean> getIsApprovalRequired() {
        return Optional.ofNullable(isApprovalRequired);
    }

    public AccessPackageAssignmentRequestRequirements withIsApprovalRequired(Boolean isApprovalRequired) {
        AccessPackageAssignmentRequestRequirements _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageAssignmentRequestRequirements");
        _x.isApprovalRequired = isApprovalRequired;
        return _x;
    }

    @Property(name="isApprovalRequiredForExtension")
    @JsonIgnore
    public Optional<Boolean> getIsApprovalRequiredForExtension() {
        return Optional.ofNullable(isApprovalRequiredForExtension);
    }

    public AccessPackageAssignmentRequestRequirements withIsApprovalRequiredForExtension(Boolean isApprovalRequiredForExtension) {
        AccessPackageAssignmentRequestRequirements _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageAssignmentRequestRequirements");
        _x.isApprovalRequiredForExtension = isApprovalRequiredForExtension;
        return _x;
    }

    @Property(name="isCustomAssignmentScheduleAllowed")
    @JsonIgnore
    public Optional<Boolean> getIsCustomAssignmentScheduleAllowed() {
        return Optional.ofNullable(isCustomAssignmentScheduleAllowed);
    }

    public AccessPackageAssignmentRequestRequirements withIsCustomAssignmentScheduleAllowed(Boolean isCustomAssignmentScheduleAllowed) {
        AccessPackageAssignmentRequestRequirements _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageAssignmentRequestRequirements");
        _x.isCustomAssignmentScheduleAllowed = isCustomAssignmentScheduleAllowed;
        return _x;
    }

    @Property(name="isRequestorJustificationRequired")
    @JsonIgnore
    public Optional<Boolean> getIsRequestorJustificationRequired() {
        return Optional.ofNullable(isRequestorJustificationRequired);
    }

    public AccessPackageAssignmentRequestRequirements withIsRequestorJustificationRequired(Boolean isRequestorJustificationRequired) {
        AccessPackageAssignmentRequestRequirements _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageAssignmentRequestRequirements");
        _x.isRequestorJustificationRequired = isRequestorJustificationRequired;
        return _x;
    }

    @Property(name="policyDescription")
    @JsonIgnore
    public Optional<String> getPolicyDescription() {
        return Optional.ofNullable(policyDescription);
    }

    public AccessPackageAssignmentRequestRequirements withPolicyDescription(String policyDescription) {
        AccessPackageAssignmentRequestRequirements _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageAssignmentRequestRequirements");
        _x.policyDescription = policyDescription;
        return _x;
    }

    @Property(name="policyDisplayName")
    @JsonIgnore
    public Optional<String> getPolicyDisplayName() {
        return Optional.ofNullable(policyDisplayName);
    }

    public AccessPackageAssignmentRequestRequirements withPolicyDisplayName(String policyDisplayName) {
        AccessPackageAssignmentRequestRequirements _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageAssignmentRequestRequirements");
        _x.policyDisplayName = policyDisplayName;
        return _x;
    }

    @Property(name="policyId")
    @JsonIgnore
    public Optional<String> getPolicyId() {
        return Optional.ofNullable(policyId);
    }

    public AccessPackageAssignmentRequestRequirements withPolicyId(String policyId) {
        AccessPackageAssignmentRequestRequirements _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageAssignmentRequestRequirements");
        _x.policyId = policyId;
        return _x;
    }

    @Property(name="questions")
    @JsonIgnore
    public CollectionPage<AccessPackageQuestion> getQuestions() {
        return new CollectionPage<AccessPackageQuestion>(contextPath, AccessPackageQuestion.class, this.questions, Optional.ofNullable(questionsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="questions")
    @JsonIgnore
    public CollectionPage<AccessPackageQuestion> getQuestions(HttpRequestOptions options) {
        return new CollectionPage<AccessPackageQuestion>(contextPath, AccessPackageQuestion.class, this.questions, Optional.ofNullable(questionsNextLink), Collections.emptyList(), options);
    }

    @Property(name="schedule")
    @JsonIgnore
    public Optional<RequestSchedule> getSchedule() {
        return Optional.ofNullable(schedule);
    }

    public AccessPackageAssignmentRequestRequirements withSchedule(RequestSchedule schedule) {
        AccessPackageAssignmentRequestRequirements _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageAssignmentRequestRequirements");
        _x.schedule = schedule;
        return _x;
    }

    public AccessPackageAssignmentRequestRequirements withUnmappedField(String name, Object value) {
        AccessPackageAssignmentRequestRequirements _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<AccessPackageAnswer> existingAnswers;
        private String existingAnswersNextLink;
        private Boolean isApprovalRequired;
        private Boolean isApprovalRequiredForExtension;
        private Boolean isCustomAssignmentScheduleAllowed;
        private Boolean isRequestorJustificationRequired;
        private String policyDescription;
        private String policyDisplayName;
        private String policyId;
        private List<AccessPackageQuestion> questions;
        private String questionsNextLink;
        private RequestSchedule schedule;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder existingAnswers(List<AccessPackageAnswer> existingAnswers) {
            this.existingAnswers = existingAnswers;
            this.changedFields = changedFields.add("existingAnswers");
            return this;
        }

        public Builder existingAnswers(AccessPackageAnswer... existingAnswers) {
            return existingAnswers(Arrays.asList(existingAnswers));
        }

        public Builder existingAnswersNextLink(String existingAnswersNextLink) {
            this.existingAnswersNextLink = existingAnswersNextLink;
            this.changedFields = changedFields.add("existingAnswers");
            return this;
        }

        public Builder isApprovalRequired(Boolean isApprovalRequired) {
            this.isApprovalRequired = isApprovalRequired;
            this.changedFields = changedFields.add("isApprovalRequired");
            return this;
        }

        public Builder isApprovalRequiredForExtension(Boolean isApprovalRequiredForExtension) {
            this.isApprovalRequiredForExtension = isApprovalRequiredForExtension;
            this.changedFields = changedFields.add("isApprovalRequiredForExtension");
            return this;
        }

        public Builder isCustomAssignmentScheduleAllowed(Boolean isCustomAssignmentScheduleAllowed) {
            this.isCustomAssignmentScheduleAllowed = isCustomAssignmentScheduleAllowed;
            this.changedFields = changedFields.add("isCustomAssignmentScheduleAllowed");
            return this;
        }

        public Builder isRequestorJustificationRequired(Boolean isRequestorJustificationRequired) {
            this.isRequestorJustificationRequired = isRequestorJustificationRequired;
            this.changedFields = changedFields.add("isRequestorJustificationRequired");
            return this;
        }

        public Builder policyDescription(String policyDescription) {
            this.policyDescription = policyDescription;
            this.changedFields = changedFields.add("policyDescription");
            return this;
        }

        public Builder policyDisplayName(String policyDisplayName) {
            this.policyDisplayName = policyDisplayName;
            this.changedFields = changedFields.add("policyDisplayName");
            return this;
        }

        public Builder policyId(String policyId) {
            this.policyId = policyId;
            this.changedFields = changedFields.add("policyId");
            return this;
        }

        public Builder questions(List<AccessPackageQuestion> questions) {
            this.questions = questions;
            this.changedFields = changedFields.add("questions");
            return this;
        }

        public Builder questions(AccessPackageQuestion... questions) {
            return questions(Arrays.asList(questions));
        }

        public Builder questionsNextLink(String questionsNextLink) {
            this.questionsNextLink = questionsNextLink;
            this.changedFields = changedFields.add("questions");
            return this;
        }

        public Builder schedule(RequestSchedule schedule) {
            this.schedule = schedule;
            this.changedFields = changedFields.add("schedule");
            return this;
        }

        public AccessPackageAssignmentRequestRequirements build() {
            AccessPackageAssignmentRequestRequirements _x = new AccessPackageAssignmentRequestRequirements();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.accessPackageAssignmentRequestRequirements";
            _x.existingAnswers = existingAnswers;
            _x.existingAnswersNextLink = existingAnswersNextLink;
            _x.isApprovalRequired = isApprovalRequired;
            _x.isApprovalRequiredForExtension = isApprovalRequiredForExtension;
            _x.isCustomAssignmentScheduleAllowed = isCustomAssignmentScheduleAllowed;
            _x.isRequestorJustificationRequired = isRequestorJustificationRequired;
            _x.policyDescription = policyDescription;
            _x.policyDisplayName = policyDisplayName;
            _x.policyId = policyId;
            _x.questions = questions;
            _x.questionsNextLink = questionsNextLink;
            _x.schedule = schedule;
            return _x;
        }
    }

    private AccessPackageAssignmentRequestRequirements _copy() {
        AccessPackageAssignmentRequestRequirements _x = new AccessPackageAssignmentRequestRequirements();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.existingAnswers = existingAnswers;
        _x.isApprovalRequired = isApprovalRequired;
        _x.isApprovalRequiredForExtension = isApprovalRequiredForExtension;
        _x.isCustomAssignmentScheduleAllowed = isCustomAssignmentScheduleAllowed;
        _x.isRequestorJustificationRequired = isRequestorJustificationRequired;
        _x.policyDescription = policyDescription;
        _x.policyDisplayName = policyDisplayName;
        _x.policyId = policyId;
        _x.questions = questions;
        _x.schedule = schedule;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AccessPackageAssignmentRequestRequirements[");
        b.append("existingAnswers=");
        b.append(this.existingAnswers);
        b.append(", ");
        b.append("isApprovalRequired=");
        b.append(this.isApprovalRequired);
        b.append(", ");
        b.append("isApprovalRequiredForExtension=");
        b.append(this.isApprovalRequiredForExtension);
        b.append(", ");
        b.append("isCustomAssignmentScheduleAllowed=");
        b.append(this.isCustomAssignmentScheduleAllowed);
        b.append(", ");
        b.append("isRequestorJustificationRequired=");
        b.append(this.isRequestorJustificationRequired);
        b.append(", ");
        b.append("policyDescription=");
        b.append(this.policyDescription);
        b.append(", ");
        b.append("policyDisplayName=");
        b.append(this.policyDisplayName);
        b.append(", ");
        b.append("policyId=");
        b.append(this.policyId);
        b.append(", ");
        b.append("questions=");
        b.append(this.questions);
        b.append(", ");
        b.append("schedule=");
        b.append(this.schedule);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
