package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "value"})
@JsonInclude(Include.NON_NULL)
public class AccessPackageAnswerString extends AccessPackageAnswer implements ODataType {

    @JsonProperty("value")
    protected String value;

    protected AccessPackageAnswerString() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.accessPackageAnswerString";
    }

    @Property(name="value")
    @JsonIgnore
    public Optional<String> getValue() {
        return Optional.ofNullable(value);
    }

    public AccessPackageAnswerString withValue(String value) {
        AccessPackageAnswerString _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageAnswerString");
        _x.value = value;
        return _x;
    }

    public AccessPackageAnswerString withUnmappedField(String name, Object value) {
        AccessPackageAnswerString _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAccessPackageAnswerString() {
        return new Builder();
    }

    public static final class Builder {
        private AccessPackageQuestion answeredQuestion;
        private String displayValue;
        private String value;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder answeredQuestion(AccessPackageQuestion answeredQuestion) {
            this.answeredQuestion = answeredQuestion;
            this.changedFields = changedFields.add("answeredQuestion");
            return this;
        }

        public Builder displayValue(String displayValue) {
            this.displayValue = displayValue;
            this.changedFields = changedFields.add("displayValue");
            return this;
        }

        public Builder value(String value) {
            this.value = value;
            this.changedFields = changedFields.add("value");
            return this;
        }

        public AccessPackageAnswerString build() {
            AccessPackageAnswerString _x = new AccessPackageAnswerString();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.accessPackageAnswerString";
            _x.answeredQuestion = answeredQuestion;
            _x.displayValue = displayValue;
            _x.value = value;
            return _x;
        }
    }

    private AccessPackageAnswerString _copy() {
        AccessPackageAnswerString _x = new AccessPackageAnswerString();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.answeredQuestion = answeredQuestion;
        _x.displayValue = displayValue;
        _x.value = value;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AccessPackageAnswerString[");
        b.append("answeredQuestion=");
        b.append(this.answeredQuestion);
        b.append(", ");
        b.append("displayValue=");
        b.append(this.displayValue);
        b.append(", ");
        b.append("value=");
        b.append(this.value);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
