package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "actualValue", 
    "displayValue"})
@JsonInclude(Include.NON_NULL)
public class AccessPackageAnswerChoice implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("actualValue")
    protected String actualValue;

    @JsonProperty("displayValue")
    protected AccessPackageLocalizedContent displayValue;

    protected AccessPackageAnswerChoice() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.accessPackageAnswerChoice";
    }

    @Property(name="actualValue")
    @JsonIgnore
    public Optional<String> getActualValue() {
        return Optional.ofNullable(actualValue);
    }

    public AccessPackageAnswerChoice withActualValue(String actualValue) {
        AccessPackageAnswerChoice _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageAnswerChoice");
        _x.actualValue = actualValue;
        return _x;
    }

    @Property(name="displayValue")
    @JsonIgnore
    public Optional<AccessPackageLocalizedContent> getDisplayValue() {
        return Optional.ofNullable(displayValue);
    }

    public AccessPackageAnswerChoice withDisplayValue(AccessPackageLocalizedContent displayValue) {
        AccessPackageAnswerChoice _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageAnswerChoice");
        _x.displayValue = displayValue;
        return _x;
    }

    public AccessPackageAnswerChoice withUnmappedField(String name, Object value) {
        AccessPackageAnswerChoice _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String actualValue;
        private AccessPackageLocalizedContent displayValue;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder actualValue(String actualValue) {
            this.actualValue = actualValue;
            this.changedFields = changedFields.add("actualValue");
            return this;
        }

        public Builder displayValue(AccessPackageLocalizedContent displayValue) {
            this.displayValue = displayValue;
            this.changedFields = changedFields.add("displayValue");
            return this;
        }

        public AccessPackageAnswerChoice build() {
            AccessPackageAnswerChoice _x = new AccessPackageAnswerChoice();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.accessPackageAnswerChoice";
            _x.actualValue = actualValue;
            _x.displayValue = displayValue;
            return _x;
        }
    }

    private AccessPackageAnswerChoice _copy() {
        AccessPackageAnswerChoice _x = new AccessPackageAnswerChoice();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.actualValue = actualValue;
        _x.displayValue = displayValue;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AccessPackageAnswerChoice[");
        b.append("actualValue=");
        b.append(this.actualValue);
        b.append(", ");
        b.append("displayValue=");
        b.append(this.displayValue);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
