package odata.msgraph.client.beta.callRecords.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum PstnCallDurationSource implements Enum {

    @JsonProperty("microsoft")
    MICROSOFT("microsoft", "0"),

    @JsonProperty("operator")
    OPERATOR("operator", "1");

    private final String name;
    private final String value;

    private PstnCallDurationSource(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
